using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Diagnostics;

using System.Net.Sockets;

namespace LocalMessenger
{
    public partial class Manager : Form
    {
        // ڑ̃o[\
        private void showBalloonTip(Messenger messenger, Member member)
        {
            managerIcon.BalloonTipTitle = "LocalMessenger";
            managerIcon.BalloonTipText = member.NickName + "̐ڑł";
            managerIcon.BalloonTipIcon = ToolTipIcon.Info;
            managerIcon.Tag = messenger;            //o[qǧĂяobZW[
            managerIcon.ShowBalloonTip(10000);      //\鎞Ԃ~bŎw肷
        }

        private void managerIcon_BalloonTipClicked(object sender, EventArgs e)
        {   // o[NbNꂽ烁bZW[ANeBx[g
            Messenger messenger = (Messenger)((NotifyIcon)sender).Tag;
            messenger.WindowState = FormWindowState.Normal;
            messenger.Show();
            messenger.Activate();
        }

        private void LocalMessenger_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (e.CloseReason == CloseReason.UserClosing)
            {
                e.Cancel = true;
                this.Visible = false;
            }
            else
            {
                finish();
            }
        }

        private void managerIcon_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            this.Visible = true;

            if (this.WindowState == FormWindowState.Minimized)
                this.WindowState = FormWindowState.Normal;

            this.Activate();
        }

        private void ConnectButton_Click(object sender, EventArgs e)
        {
            listView.Focus();
            connect();
        }

        private void listView_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            connect();
        }

        private void Memo_Leave(object sender, EventArgs e)
        {
            user.Memo = memo.Text;
            notifier.Broadcast();
        }

        private void Memo_KeyPress(object sender, KeyPressEventArgs e)
        {
            //EnterEscapeL[Ńr[vȂ悤ɂ
            if ((e.KeyChar == (char)Keys.Enter) ||
                (e.KeyChar == (char)Keys.Escape))
            {
                e.Handled = true;
                ConnectButton.Focus();
            }
        }

        private void wvToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Help.ShowHelp(this, "LocalMessenger.chm");
        }
    }
}