using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Diagnostics;

using System.Collections;
using System.IO;
using System.Runtime.InteropServices;

namespace LocalMessenger
{
    public delegate void ClosedHandler(Messenger messenger);

    public partial class Messenger : Form
    {
        [DllImport("user32.dll")]
        static extern Int32 FlashWindowEx(ref FLASHWINFO pwfi);

        [StructLayout(LayoutKind.Sequential)]
        public struct FLASHWINFO
        {
            public UInt32 cbSize;    // FLASHWINFO\̂̃TCY
            public IntPtr hwnd;      // _őΏۂ̃EBhEEnh
            public UInt32 dwFlags;   // ȉ́uFLASHW_XXXv̂ꂩ
            public UInt32 uCount;    // _ł
            public UInt32 dwTimeout; // _łԊui~bPʁj
        }

        // _ł~߂
        public const UInt32 FLASHW_STOP = 0;
        // ^Cgo[_ł
        public const UInt32 FLASHW_CAPTION = 1;
        // ^XNo[E{^_ł
        public const UInt32 FLASHW_TRAY = 2;
        // ^XNo[E{^ƃ^Cgo[_ł
        public const UInt32 FLASHW_ALL = 3;
        // FLASHW_STOPw肳܂łƓ_ł
        public const UInt32 FLASHW_TIMER = 4;
        // EBhEőOʂɗ܂łƓ_ł
        public const UInt32 FLASHW_TIMERNOFG = 12;

        public event ClosedHandler closed;    // bZW[̃Cxg

        private Manager manager;
        private List<string> files;
        private ImageList imageList;

        private int imageIndex = 0;

        public void BlinkTitleBar()
        {
            FLASHWINFO flashInfo = new FLASHWINFO();
            
            flashInfo.cbSize = Convert.ToUInt32(Marshal.SizeOf(flashInfo));
            flashInfo.hwnd = this.Handle;
            flashInfo.dwFlags = FLASHW_ALL + FLASHW_TIMERNOFG;
            flashInfo.uCount = 0;
            flashInfo.dwTimeout = 0;

            FlashWindowEx(ref flashInfo);
        }
        
        public Messenger(Manager manager)
        {
            InitializeComponent();
            this.messageBox.AllowDrop = true;
            this.messageBox.DragEnter += new 
                System.Windows.Forms.DragEventHandler(this.Messenger_DragEnter);
            this.messageBox.DragDrop += new
                System.Windows.Forms.DragEventHandler(this.Messenger_DragDrop);

            this.manager = manager;
            manager.updated += new UpdatedHandler(listUpdated);

            this.fileListView.Visible = false;
            imageList = new ImageList();
            imageList.ImageSize = new Size(32, 32);
            fileListView.LargeImageList = imageList;
            files = new List<string>();

            imageStatus.Images.Add(Properties.Resources.Status0);
            imageStatus.Images.Add(Properties.Resources.Status1);
            imageStatus.Images.Add(Properties.Resources.Status2);
            imageStatus.Images.Add(Properties.Resources.Status3);
            imageStatus.Images.Add(Properties.Resources.Status4);
            imageStatus.Images.Add(Properties.Resources.Status5);
            imageStatus.Images.Add(Properties.Resources.Status6);
            imageStatus.Images.Add(Properties.Resources.Status7);
            imageStatus.Images.Add(Properties.Resources.Status8);
            imageStatus.Images.Add(Properties.Resources.Status9);

            listView.SmallImageList = imageStatus;

            int margin = listView.Margin.Left + listView.Margin.Right;
            listView.Columns.Add("o[Xg", listView.Width - margin,
                HorizontalAlignment.Left);
        }

        public void listMember()
        {
            listView.Items.Clear();

            ArrayList items = new ArrayList();
            ListViewItem item;

            foreach (ContactMember contact in memberList)
            {
                string[] info =
                {
                    contact.Member.NickName,
                    contact.Member.Memo
                };

                item = new ListViewItem(info, (int)contact.Member.Status);
                item.ToolTipText = contact.Member.Name + "@" + contact.Member.Machine
                    + " [" + contact.Member.Address + "] ";
                item.Tag = contact;
                items.Add(item);
            }

            listView.Items.AddRange((ListViewItem[])items.ToArray(typeof(ListViewItem)));
        }

        private void listUpdated(List<ContactMember> list)
        {
            listMember();
        }

        // t@CXg̍폜
        private void clearFileList()
        {
            fileListView.Clear();
            fileListView.Visible = false;
            files.Clear();
            imageList.Images.Clear();
            imageIndex = 0;
        }

        private void buttonSend_Click(object sender, EventArgs e)
        {
            SendMessage(files);

            if (files.Count > 0)
            {   // t@CXg폜
                clearFileList();
            }
        }

        private void invite_Click(object sender, EventArgs e)
        {
            Member member = (Member)((ToolStripMenuItem)sender).Tag;
            manager.Invite(this, member);
        }

        private void ToolStripMenuItem_MouseEnter(object sender, EventArgs e)
        {
            ToolStripMenuItem.DropDownItems.Clear();

            foreach (ContactMember contact in manager.MemberList)
                if (GetMemberList().Contains(contact.Member) == false)
                {
                    ToolStripMenuItem item = new ToolStripMenuItem();
                    item.Click += new EventHandler(invite_Click);
                    item.Text = contact.Member.NickName + "@" + contact.Member.Machine;
                    item.Tag = contact.Member;
                    ToolStripMenuItem.DropDownItems.Add(item);
                }
        }

        private void Messenger_FormClosed(object sender, FormClosedEventArgs e)
        {
            if (closed != null)
                closed(this);
        }

        private void Messenger_DragDrop(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop))
            {   // t@ChbOhbvꂽƂ
                List<string> paths = new List<string>((string[])e.Data.GetData(DataFormats.FileDrop));

                //ACRXg̍쐬
                foreach (string path in paths)
                {
                    FileInfo info = new FileInfo(path);
                    if ((info.Attributes & FileAttributes.Directory) ==
                        FileAttributes.Directory)
                    {   // fBNg͏O
                        continue;
                    }
                    if (files.Contains(path))
                    {   // ɑ݂ĂΏO
                        continue;
                    }
                    files.Add(path);
                    Icon appIcon = System.Drawing.Icon.ExtractAssociatedIcon(path);
                    imageList.Images.Add(appIcon);
                    // Create items and add them to myListView.
                    ListViewItem item = new ListViewItem(info.Name, imageIndex++);

                    fileListView.Items.Add(item);
                }

                if (files.Count > 0)
                {
                    fileListView.Visible = true;
                }
            }
        }

        private void Messenger_DragEnter(object sender, DragEventArgs e)
        {
            e.Effect = DragDropEffects.Copy;
        }

        private void messageLog_LinkClicked(object sender, LinkClickedEventArgs e)
        {
            Process.Start(e.LinkText);
        }

        private static int CompareIndex(int x, int y)
        {
            if (x == y)
                return 0;
            else if (x > y)
                return -1;
            else if (x < y)
                return 1;
            return 0;
        }

        private void fileListView_KeyDown(object sender, KeyEventArgs e)
        {
            if (fileListView.Visible == true)
            {
                if (e.KeyCode == Keys.Delete)
                {
                    ListView.SelectedIndexCollection indexes = fileListView.SelectedIndices;
                    List<int> SortedIndex = new List<int>();

                    foreach (int index in indexes)
                    {
                        SortedIndex.Add(index);
                    }
                    // ListView͍폜index̂Ō납폜
                    SortedIndex.Sort(CompareIndex);

                    foreach(int index in SortedIndex)
                    {
                        Debug.WriteLine(index + ":" + fileListView.Items[index].ToString());
                        fileListView.Items.RemoveAt(index);
                        files.RemoveAt(index);
                    }

                    if (files.Count == 0)
                    {   // t@CXg̍폜
                        clearFileList();
                    }
                }
            }
        }
    }
}
