using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;

using System.Diagnostics;

namespace LocalMessenger
{
    class FileButton
    {
        //{^Rg[z̃tB[h쐬
        private System.Windows.Forms.Button button;
        private Point pos;
        private List<string> files;
        private Member member;
        private Manager manager;

        public System.Windows.Forms.Button Button
        {
            get { return button; }
        }

        public FileButton(Manager manager, Member member, 
            List<string> files, int x, int y)
        {
            pos.X = x;
            pos.Y = y - 2;

            this.files   = files;
            this.member  = member;
            this.manager = manager;

            //{^Rg[̍쐬
            button = new System.Windows.Forms.Button();
            //vpeBݒ
            button.Name = "fileButton";
            button.Text = "M";
            button.Size = new Size(40, 20);
            button.Location = new Point(pos.X, pos.Y);
            //CxgnhɊ֘At
            button.Click += new EventHandler(button_Click);
        }

        public void SetButtonPos(int dy)
        {
            button.Location = new Point(pos.X, pos.Y - dy);
        }

        // ButtoñNbNCxgnh
        private void button_Click(object sender, EventArgs e)
        {   // t@C]v𑗐M
            List<Member> memberList = new List<Member>();

            foreach (ContactMember contact in manager.MemberList)
                memberList.Add(contact.Member);

            manager.RequestFile(member, memberList, files);
        }
    }
}
