/*
 * Copyright (C) 2014 kgto.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301  USA
 */
/*
 * $Id: AttributeData.java 57 2014-07-29 04:59:32Z tuna_p $
 */

package Lib;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;

/**
 *
 * @author kgto
 */
public class AttributeData {
    
    public AttributeData() {
        AttrList = new ArrayList();
        size     = 0;
    }
    
    public void add(HTML.Tag tag, MutableAttributeSet attr) {
        
        int tagcount = tagcnt(tag);
        ++tagcount;
        
        Enumeration e = attr.getAttributeNames();
        while(e.hasMoreElements()) {
            Object obj = e.nextElement();
            
            AttrData a = new AttrData();
            a.tag = tag;
            a.count = tagcount;
            a.attrname  = obj.toString();
            a.attrvalue = attr.getAttribute(obj).toString();
            
            AttrList.add(a);
            size = AttrList.size();
        }
        
    }
    
    public boolean search(HTML.Tag tag, String attrname, String attrvalue) {
        boolean ret = false;
        for (Object AttrList1 : AttrList) {
            AttrData a = (AttrData)AttrList1;
            if(a.tag == tag) {
                if(a.attrname.equals(attrname) && a.attrvalue.equals(attrvalue)) {
                    ret = true;
                }
            }            
        }
        return ret;
    }
    
    public boolean searchId(HTML.Tag tag, String attrvalue) {
        return search(tag, "id", attrvalue);
    }
    
    public boolean searchClass(HTML.Tag tag, String attrvalue) {
        return search(tag, "class", attrvalue);
    }
    
    /**
     * 属性の値を取得する.
     * @param tag
     * @param attrname
     * @return 
     */
    public ArrayList getvale(HTML.Tag tag, String attrname) {
        ArrayList ret = new ArrayList();
        for (Object AttrList1 : AttrList) {
            AttrData a = (AttrData)AttrList1;
            if(a.tag == tag) {
                if(a.attrname.equals(attrname)) {
                    ret.add(a.attrvalue);
                }
            }
        }
        return ret;
    }
    
    /**
     * 引数で渡されたTAGの最新カウント数を返す.
     * @param tag
     * @return 
     */
    private int tagcnt(HTML.Tag tag) {
        int wkcnt = 0;
        for (Object AttrList1 : AttrList) {
            AttrData a = (AttrData)AttrList1;
            if(a.tag == tag) {
                if(wkcnt < a.count) {
                    wkcnt = a.count;
                }
            }
        }
        return wkcnt;
    }
    
    // AttrList の内容を返すメソッド
    public HTML.Tag gettag(int i) {
        AttrData a = (AttrData)AttrList.get(i);
        return a.tag;
    }

    public int getcount(int i) {
        AttrData a = (AttrData)AttrList.get(i);
        return a.count;
    }

    public String getattrname(int i) {
        AttrData a = (AttrData)AttrList.get(i);
        return a.attrname;
    }
    
    public String getattrvalue(int i) {
        AttrData a = (AttrData)AttrList.get(i);
        return a.attrvalue;
    }

    // フィールド変数
    public class AttrData {
        public HTML.Tag tag;
        public int count;
        public String attrname;
        public String attrvalue;
    }
    public ArrayList AttrList;
    public int size;  // AttrListのサイズ
    
}
