﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Windows;
using Forms = System.Windows.Forms;

namespace JoinNotes
{
    /// <summary>
    /// Application.xaml の相互作用ロジック
    /// </summary>
    public partial class App : Application
    {
        internal const int WM_HOTKEY = 0x312;
        internal const int WM_ACTIVATEAPP = 0x1C;
        internal const int WM_APP = 0x8000;
        internal const int WM_APP_ACTIVATEAPP = WM_APP + 1;
        internal const int SW_RESTORE = 9;

        internal static Dictionary<string, int> HotKeyId = new Dictionary<string, int> { };
        internal static Dictionary<string, HotKey> HotKey = new Dictionary<string, HotKey> { };

        internal static Search searchWindow;
        internal static Config configWindow;
        internal static Forms.Form aboutWindow;
        //internal static Menu mainWindow;
        internal static NotifyTray mainWindow;
        //internal static Menu NotifyContainer { get; set; }
        internal static Window NotifyContainer { get; set; }
        internal static FileInfo HelpFile;
        //internal string basepath;
        internal static DirectoryInfo DocumentPath;
        internal static DirectoryInfo DocumentPathDefault;

        //internal static Window MainWindow { get; private set; }
        internal static App Instance { get; private set; }

        internal Dictionary<Uri, Editor> EditorWindows = new Dictionary<Uri, Editor> { };
        internal HashSet<Editor> UntitledEditorWindows = new HashSet<Editor> { };

        internal static string NotifyContainerTitle { get; private set; }
        internal static Microsoft.VisualBasic.ApplicationServices.AssemblyInfo AssemblyInfo { get; private set; }

        static Application()
        {
            __t.test();
        }

        protected override void OnStartup(StartupEventArgs e)
        {
            App.Instance = this;
            App.AssemblyInfo = new Microsoft.VisualBasic.ApplicationServices.AssemblyInfo(Assembly.GetExecutingAssembly());

            App.NotifyContainerTitle = Assembly.GetEntryAssembly().GetName().Name + " " + this.GetType().Name;

            var current = Process.GetCurrentProcess();


            //HACK: なぜかApplication.xamlの<Application.Resources>セクションで定義するとデザイン時にファイルが見つからないエラーが出るので、ここで指定。
            this.Resources.Source = new Uri(@"pack://application:,,,/JoinNotes;component/Themes/Generic.xaml");

            App.HelpFile = new FileInfo("JoinNotes.chm");

            //// デバッグ用
            //var otherProcs = Process.GetProcessesByName("JoinNotes").ToList();
            //otherProcs.AddRange(Process.GetProcessesByName("JoinNotes.vshost"));
            //otherProcs = otherProcs.Where(p => p.Id != current.Id).ToList();

            //FIXME: リリース時はこちら
            var otherProcs = Process.GetProcessesByName(current.ProcessName).Where(p => p.MainModule.FileName == current.MainModule.FileName && p.Id != current.Id).ToList();

            if (otherProcs.Count() == 0)
            {
<<<<<<< HEAD:Application.xaml.cs
                Application.Current.MainWindow = Application.mainWindow;
                //Application.Current.MainWindow = Application.searchWindow;
=======
                App.Current.MainWindow = App.mainWindow;
                //App.Current.MainWindow = App.searchWindow;
>>>>>>> parent of 23cda42... ver 0.1.1:App.xaml.cs

                ////FIXME: remove
                //Application.Current.MainWindow.Show();

                base.OnStartup(e);
            }
            else
            {
                Debug.Assert(otherProcs.Count() >= 1);
                otherProcs.ForEach(new Action<Process>((p) => Debug.WriteLine(new { p.MainWindowHandle, p.MainWindowTitle }, "Send wakeup message to ")));
                //Util.WakeupWindow(otherProcs.First().MainWindowHandle);
                Util.WakeupWindow(otherProcs.First());
                //Util.WakeupWindow(otherProcs.First().Handle);
                this.Shutdown();
            }
        }

        //FIXME: OnStartupと統合
        void Application_Startup(object sender, StartupEventArgs e)
        {
            //{
            //    var activateHotKey = new HotKey(Application.mainWindow.Handle,
            //        Menu.HotKey_ActivateHotKeyId,
            //        System.Windows.Forms.Keys.Oem5, // Oem5: \
            //        System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.Alt); //HACK: Keys.AltはShiftキーのこと。
            //    Menu.HotKey_ActivateHotKey = activateHotKey;
            //}

            //searchWindow.Show();
            //editorWindow.Owner = Application.Current.MainWindow;

            //mainWindow.Show();
            //editorWindow.Show();
            //searchWindow.Show();
            //configWindow.Show();

            this.ShutdownMode = System.Windows.ShutdownMode.OnExplicitShutdown;

<<<<<<< HEAD:Application.xaml.cs
            //Application.mainWindow = new Menu();
            Application.mainWindow = new NotifyTray();
            Application.NotifyContainer = Application.mainWindow;
=======
            //App.mainWindow = new Menu();
            App.mainWindow = new NotifyTray();
            App.NotifyContainer = App.mainWindow;
>>>>>>> parent of 23cda42... ver 0.1.1:App.xaml.cs

            //HACK: 一度表示しないとなぜかプロセス外からEnumWindows()で発見できないので
            App.NotifyContainer.Show();
            App.NotifyContainer.Hide();

            App.searchWindow = new Search();
            App.configWindow = new Config();
            App.aboutWindow = new AboutBox1();

            Application.Current.MainWindow.Closed += new EventHandler(Window_Closed);
            configWindow.Closed += new EventHandler(Window_Closed);

            InvokeStartupTask();

            //Application.Current.MainWindow.Show();
        }

        internal void InvokeStartupTask()
        {
            //FIXME: スタートアップ時に開くウィンドウは別の設定項目に
            var classname = JoinNotes.Properties.Settings.Default.StartupWindowClassName;
            Window startupWindow;
            if (classname == typeof(Editor).Name)
                startupWindow = Editor.Create(Util.ValidateFilename(JoinNotes.Properties.Settings.Default.StartPageName) + @".join.rtf");
            else
                startupWindow = this.GetWindow(classname);

            startupWindow.Show();
            startupWindow.Activate();
        }

        //void App_Startup(object sender, StartupEventArgs e)
        //{
        //    Debug.Assert(Application.mainWindow != null && Application.mainWindow is NotifyTray);
        //    //Application.NotifyContainer = new Menu();
        //    Application.NotifyContainer = Application.mainWindow;
        //}

        //FIXME: Application_Exitと統合
        protected override void OnExit(ExitEventArgs e)
        {
            base.OnExit(e);

            if (searchWindow != null)
                searchWindow.Close();
            if (configWindow != null)
                configWindow.Close();
            if (mainWindow != null)
                mainWindow.Close();
        }

        void Window_Closed(object sender, EventArgs e)
        {
            var c = (Window)sender;

            if (hiddenWindows.Contains(c))
                hiddenWindows.Remove(c);
        }

        void Application_Exit(object sender, ExitEventArgs e)
        {
            App.NotifyContainer.Close();

            if (App.HotKey["ActivateHotKey"] != null)
                try
                {
                    App.HotKey["ActivateHotKey"].Unregister();
                }
                catch (Win32Exception ex)
                {
                    Debug.WriteLine(ex.Message, ex.Source);
                }
        }

        internal Window GetWindow(string classname)
        {
            Window ret;

            //FIXME: ComboBoxでのラベルと設定値の対応付け方法
            if (classname == typeof(Editor).Name)
            {
                ret = Editor.Create();

                //FIXME: GetWindowかEditor.Create()か一方に統一
                //FIXME: Create(string) -> Create(ValidFilename型)
                //ret = Editor.Create(Util.ValidateFilename(JoinNotes.Properties.Settings.Default.StartPageName) + @".join.rtf");
            }
            else if (classname == typeof(Search).Name)
            {
                if (App.searchWindow == null)
                    App.searchWindow = new Search();
                ret = App.searchWindow;
            }
            else if (classname == typeof(Config).Name)
            {
                if (App.configWindow == null)
                    App.configWindow = new Config();
                ret = App.configWindow;
            }
            else if (classname == typeof(NotifyTray).Name)
            {
                if (App.mainWindow == null)
                    App.mainWindow = new NotifyTray();
                ret = App.mainWindow;
            }
            else
            {
                ret = null;
                Debug.Fail("GetWindow", "classname: " + classname);
            }

            return ret;
        }

        internal static void SwitchApplicationVisibility()
        {
            // ウィンドウが1つでも表示されていれば、全てを記録して非表示。1つも表示されていなければ記録してあるWindowを全て表示。
            var ws = new List<Window>(Application.Current.Windows.Cast<Window>());
            if (ws.Exists(w => w.IsVisible))
                InactivateWindows();
            else
                ActivateWindows();
        }

        private static HashSet<Window> hiddenWindows = new HashSet<Window> { };
        internal static void InactivateWindows()
        {
            App.hiddenWindows.Clear();

            var ws = new List<Window>(Application.Current.Windows.Cast<Window>());
            foreach (var w in ws.Where(w => w.IsVisible))
            {
                w.Visibility = Visibility.Collapsed;
                App.hiddenWindows.Add(w);
            }
        }

        internal static void ActivateWindows()
        {
            var ws = new List<Window>(Application.Current.Windows.Cast<Window>());
            foreach (var w in ws.Where(w => App.hiddenWindows.Contains(w)))
            {
                w.Show();
                if (w.WindowState == WindowState.Minimized)
                    w.WindowState = WindowState.Normal;
                w.Activate();
<<<<<<< HEAD:Application.xaml.cs
                Application.hiddenWindows.Remove(w);
            }
        }

        void ApplySettings()
        {
            // 設定の読み込み・有効化

            {
                //FIXME: ActivateHotkeyを型にあった名前に
                var hotKeyName = "ActivateHotKey";
                ApplySettings2(hotKeyName);
            }
            {
                //FIXME: OpenWindowHotKeyを型にあった名前に
                var hotKeyName = "OpenWindowHotKey";
                ApplySettings2(hotKeyName);
            }

            //try
            //{
            //    //FIXME: OpenWindowHotKeyを型にあった名前に
            //    var keys = Properties.Settings.Default.OpenWindowHotKey;
            //    //var hotKey = new HotKey(Application.mainWindow.Handle,
            //    var hotKey = new HotKey(new WindowInteropHelper(Application.mainWindow).Handle,
            //        NotifyTray.HotKey_OpenWindowHotKeyId,
            //        keys & Forms.Keys.KeyCode,
            //        keys & Forms.Keys.Modifiers);
            //    NotifyTray.HotKey_OpenWindowHotKey = hotKey;
            //}
            //catch (Win32Exception ex)
            //{
            //    Debug.WriteLine(ex.Message, ex.Source);
            //}

            try
            {
                Application.DocumentPathDefault = new DirectoryInfo(Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments, Environment.SpecialFolderOption.None), @"JoinNotes"));

                //FIXME: 設定をApplicationに置くかConfigに置くか
                Application.DocumentPath = (JoinNotes.Properties.Settings.Default.DocumentPath == "")
                    ? new DirectoryInfo(Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments, Environment.SpecialFolderOption.None), Application.AssemblyInfo.ProductName))
                    : new DirectoryInfo(JoinNotes.Properties.Settings.Default.DocumentPath);
                //FIXME: ディレクトリが無ければモードレスな警告をするだけに。ディレクトリ設定はデフォルトと見なす。
                if (!Application.DocumentPath.Exists) Application.DocumentPath.Create();
            }
            catch (Exception ex)
            {
                Debug.WriteLine(ex.Message, ex.Source);
            }
        }

        private void ApplySettings2(string hotKeyName)
        {
            try
            {
                var keys = (Forms.Keys)JoinNotes.Properties.Settings.Default[hotKeyName];
                //var hotKey = new HotKey(Application.mainWindow.Handle,
                var hotKey = new HotKey(new WindowInteropHelper(Application.mainWindow).Handle,
                    Application.HotKeyId[hotKeyName],
                    keys & Forms.Keys.KeyCode,
                    keys & Forms.Keys.Modifiers);
                Application.HotKey[hotKeyName] = hotKey;
            }
            catch (Win32Exception ex)
            {
                Debug.WriteLine(ex.Message, ex.Source);
=======
                App.hiddenWindows.Remove(w);
>>>>>>> parent of 23cda42... ver 0.1.1:App.xaml.cs
            }
        }

    }

}
