package jp.gr.java_conf.wutse.purewiki;

import java.io.File;

public class PureWikiData implements Comparable<PureWikiData> {
	private String wikiName = null;
	private String path = null;
	private String orgWikiText = null;
	private long lastModified = 0L;
	private String wikiText = null;
	private File srcFile = null;
	private File outFile = null;

	/**
	 * Newモードで作成
	 */
	public PureWikiData() {}

	/**
	 * リソースファイル
	 * 
	 * @param dataName
	 * @param srcFile
	 * @param outFile
	 */
	public PureWikiData(String path, File srcFile, File outFile) {
		this.path = path;
		this.srcFile = srcFile;
		this.outFile = outFile;
	}

	public PureWikiData(String path, File srcFile, File outFile, String wikiName, String wikiText) {
		this.path = path;
		this.srcFile = srcFile;
		this.outFile = outFile;
		this.orgWikiText = wikiText;
		this.wikiText = wikiText;
	}

	public boolean isWiki() {
		if (srcFile == null) {
			return true;
		}
		else if (srcFile.getName().endsWith(".wiki")) {
			return true;
		}
		else {
			return false;
		}
	}

	public String getWikiName() {
		return wikiName;
	}

	public void setWikiName(String wikiName) {
		this.wikiName = wikiName;
	}

	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}

	public String getOrgWikiText() {
		return orgWikiText;
	}

	public void setOrgWikiText(String orgWikiText) {
		this.orgWikiText = orgWikiText;
	}

	public long getLastModified() {
		return lastModified;
	}

	public void setLastModified(long lastModified) {
		this.lastModified = lastModified;
	}

	public String getWikiText() {
		return wikiText;
	}

	public void setWikiText(String wikiText) {
		this.wikiText = wikiText;
	}

	public File getSrcFile() {
		return srcFile;
	}

	public void setSrcFile(File srcFile) {
		this.srcFile = srcFile;
	}

	public File getOutFile() {
		return outFile;
	}

	public void setOutFile(File outFile) {
		this.outFile = outFile;
	}

	public String getUrl() {
		if (outFile == null) {
			return "about:blank";
		}
		else {
			return "file:///" + outFile.getAbsolutePath().replaceAll("\\\\", "/");
		}
	}

	public boolean isNew() {
		return srcFile == null;
	}

	public boolean isModified() {
		if (orgWikiText == null && wikiText == null) {
			return false;
		}
		else if (orgWikiText == null && wikiText != null) {
			return true;
		}
		else if (orgWikiText != null && wikiText == null) {
			return true;
		}
		else {
			return !orgWikiText.equals(wikiText);
		}
	}

	public boolean isLoaded() {
		return orgWikiText != null;
	}

	@Override
	public int compareTo(PureWikiData target) {
		return wikiName.compareToIgnoreCase(target.wikiName);
	}

}
