package jp.gr.java_conf.wutse.purewiki.syntax.line;

import jp.gr.java_conf.wutse.purewiki.PureWikiContext;
import jp.gr.java_conf.wutse.purewiki.syntax.LineSyntax;

public class UlSyntax implements LineSyntax {
	private static final String UL_LEVEL = "purewiki.ulLevel";

	@Override
	public boolean condition(PureWikiContext context) {
		String line = context.getLine();
		if (line.startsWith("* ") || line.startsWith("** ") || line.startsWith("*** ")) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public String begin(PureWikiContext context) {
		String line = context.getLine();
		StringBuffer sb = new StringBuffer();
		int level = 0;
		if (line.startsWith("* ")) {
			level = 1;
		}
		else if (line.startsWith("** ")) {
			level = 2;
		}
		else if (line.startsWith("*** ")) {
			level = 3;
		}
		for (int i = 0; i < level; i++) {
			sb.append("<UL>");
		}
		context.setAttribute(UL_LEVEL, level);
		return sb.toString();
	}

	@Override
	public String line(PureWikiContext context) {
		if (!condition(context)) {
			return context.getLine() + "<BR>\n";
		}
		String line = context.getLine();
		Integer currentLevel = (Integer)context.getAttribute(UL_LEVEL);
		StringBuffer sb = new StringBuffer();

		LineSyntax currentSyntax = context.getCurrentLineSyntax();
		if (currentSyntax == this) {
			sb.append("</LI>");
		}

		int level = 0;
		if (line.startsWith("* ")) {
			level = 1;
		}
		else if (line.startsWith("** ")) {
			level = 2;
		}
		else if (line.startsWith("*** ")) {
			level = 3;
		}
		int count = level - currentLevel;
		if (count > 0) {
			for (int i = 0; i < count; i++) {
				sb.append("<UL>");
			}
		}
		else if (count < 0) {
			for (int i = 0; i > count; i--) {
				sb.append("</UL>");
			}
		}
		sb.append("<LI>");
		sb.append(line.substring(level + 1));
		sb.append("<BR>");

		context.setAttribute(UL_LEVEL, level);
		return sb.toString();
	}

	@Override
	public String end(PureWikiContext context) {
		Integer currentLevel = (Integer)context.getAttribute(UL_LEVEL);
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < currentLevel; i++) {
			sb.append("</UL>\n");
		}
		return sb.toString();
	}

}
