package jp.gr.java_conf.wutse.purewiki.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.nio.channels.FileChannel;

public class PureWikiUtil {
	public static String loadFile(File file) {
		try {
			return loadStream(new FileInputStream(file));
		}
		catch (FileNotFoundException ex) {
			return "";
		}
	}

	public static String loadStream(InputStream is) {
		BufferedReader reader = null;
		StringWriter writer = new StringWriter();
		try {
			reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
			while (reader.ready()) {
				writer.write(reader.readLine());
				writer.write(System.lineSeparator());
			}
		}
		catch (IOException ex) {
			ex.printStackTrace();
		}
		finally {
			close(reader);
		}
		return writer.toString();
	}

	public static void storeFile(File file, String text) {
		try {
			File parent = file.getParentFile();
			if (!parent.exists()) {
				parent.mkdirs();
			}
			storeStream(new FileOutputStream(file), text);
		}
		catch (FileNotFoundException ex) {}
	}

	public static void storeStream(OutputStream os, String text) {
		OutputStreamWriter writer = null;
		try {
			writer = new OutputStreamWriter(os, "UTF-8");
			writer.write(text);
			writer.flush();
		}
		catch (IOException ex) {
			ex.printStackTrace();
		}
		finally {
			close(writer);
		}
	}

	public static void copyFile(File srcFile, File outFile) throws IOException {
		FileChannel ifc = null;
		FileChannel ofc = null;
		FileInputStream fis = null;
		FileOutputStream fos = null;
		try {
			// 入力元ファイルのストリームからチャネルを取得
			fis = new FileInputStream(srcFile);
			ifc = fis.getChannel();

			// 出力先ファイルのチャネルを取得
			fos = new FileOutputStream(outFile);
			ofc = fos.getChannel();

			// バイトを転送します。
			ifc.transferTo(0, ifc.size(), ofc);
		}
		finally {
			close(fis);
			close(fos);
			close(ifc);
			close(ofc);
		}
	}

	private static final int BUFFER_SIZE = 8000;

	public static void copyStream(InputStream is, OutputStream os) throws IOException {
		try {
			byte[] buffer = new byte[BUFFER_SIZE];
			int readBytes = 0;
			do {
				readBytes = is.read(buffer);
				if (readBytes == 0) {
					break;
				}
				os.write(buffer, 0, readBytes);
			}
			while (readBytes == BUFFER_SIZE);
		}
		finally {
			close(is);
			close(os);
		}
	}

	public static void clearDirectory(File dir) {
		if (!dir.isDirectory()) {
			return;
		}
		File[] files = dir.listFiles();
		for (File file : files) {
			if (file.isDirectory()) {
				clearDirectory(file);
				file.delete();
			}
			else {
				file.delete();
			}
		}
	}

	public static void close(Closeable closable) {
		if (closable != null) {
			try {
				closable.close();
			}
			catch (IOException ex) {}
		}
	}

	public static boolean isBlank(String text) {
		if (text == null || text.length() == 0) {
			return true;
		}
		else {
			return false;
		}
	}

}
