/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.jpa.metadata;

import java.util.concurrent.ConcurrentMap;
import org.seasar.framework.jpa.PersistenceUnitManager;
import org.seasar.framework.jpa.PersistenceUnitManagerLocater;
import org.seasar.framework.jpa.PersistenceUnitProvider;
import org.seasar.framework.jpa.metadata.AttributeDesc;
import org.seasar.framework.jpa.metadata.EntityDesc;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DisposableUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityDescFactory {
    protected static final EntityDesc NOT_FOUND = new NotFound();
    protected static boolean initialized;
    protected static final ConcurrentMap<Class<?>, EntityDesc> entityDescs;

    public static void initialize() {
        if (initialized) {
            return;
        }
        DisposableUtil.add((Disposable)new Disposable(){

            public void dispose() {
                EntityDescFactory.clear();
            }
        });
        initialized = true;
    }

    public static void clear() {
        entityDescs.clear();
        initialized = false;
    }

    public static EntityDesc getEntityDesc(Class<?> entityClass) {
        EntityDescFactory.initialize();
        EntityDesc entityDesc = (EntityDesc)entityDescs.get(entityClass);
        if (entityDesc != null) {
            return entityDesc == NOT_FOUND ? null : entityDesc;
        }
        return EntityDescFactory.createEntityDesc(entityClass);
    }

    protected static EntityDesc createEntityDesc(Class<?> entityClass) {
        PersistenceUnitManager manager = PersistenceUnitManagerLocater.getInstance();
        PersistenceUnitProvider unitProvider = manager.getPersistenceUnitProvider(manager.getConcretePersistenceUnitName(entityClass));
        EntityDesc entityDesc = unitProvider.getEntityDescProvider().createEntityDesc(unitProvider.getEntityManagerFactory(), entityClass);
        if (entityDesc == null) {
            CollectionsUtil.putIfAbsent(entityDescs, entityClass, NOT_FOUND);
            return null;
        }
        return CollectionsUtil.putIfAbsent(entityDescs, entityClass, entityDesc);
    }

    static {
        entityDescs = CollectionsUtil.newConcurrentHashMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NotFound
    implements EntityDesc {
        private NotFound() {
        }

        @Override
        public AttributeDesc getAttributeDesc(String attributeName) {
            return null;
        }

        @Override
        public AttributeDesc[] getAttributeDescs() {
            return null;
        }

        @Override
        public String[] getAttributeNames() {
            return null;
        }

        @Override
        public Class<?> getEntityClass() {
            return null;
        }

        @Override
        public String getEntityName() {
            return null;
        }

        @Override
        public AttributeDesc getIdAttributeDesc() {
            return null;
        }
    }
}

