/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.unit;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.unit.ClassExtensionEacyMockDelegator;
import org.seasar.framework.unit.DefaultEacyMockDelegator;
import org.seasar.framework.unit.EasyMockDelegator;
import org.seasar.framework.unit.annotation.EasyMock;
import org.seasar.framework.unit.annotation.EasyMockType;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyMockSupport {
    protected static final EasyMockDelegator easyMock = EasyMockSupport.getEasyMockDelegator();
    protected List<Object> mocks = CollectionsUtil.newArrayList();
    protected Set<Field> boundFields = CollectionsUtil.newLinkedHashSet();

    public <T> T createMock(Class<T> clazz) {
        T mock = easyMock.createMock(clazz);
        this.mocks.add(mock);
        return mock;
    }

    public <T> T createNiceMock(Class<T> clazz) {
        T mock = easyMock.createNiceMock(clazz);
        this.mocks.add(mock);
        return mock;
    }

    public <T> T createStrictMock(Class<T> clazz) {
        T mock = easyMock.createStrictMock(clazz);
        this.mocks.add(mock);
        return mock;
    }

    public void replay() {
        for (Object mock : this.mocks) {
            easyMock.replay(mock);
        }
    }

    public void verify() {
        for (Object mock : this.mocks) {
            easyMock.verify(mock);
        }
    }

    public void reset() {
        for (Object mock : this.mocks) {
            easyMock.reset(mock);
        }
    }

    public void clear() {
        this.mocks.clear();
        this.boundFields.clear();
    }

    public void bindMockFields(Object test, S2Container container) {
        this.boundFields.clear();
        for (Class<?> clazz = test.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                this.bindMockField(field, test, container);
            }
        }
    }

    protected void bindMockField(Field field, Object test, S2Container container) {
        EasyMock annotation = field.getAnnotation(EasyMock.class);
        if (annotation == null) {
            return;
        }
        field.setAccessible(true);
        if (FieldUtil.get((Field)field, (Object)test) != null) {
            return;
        }
        Class<?> clazz = field.getType();
        EasyMockType mockType = annotation.value();
        Object mock = mockType == EasyMockType.STRICT ? this.createStrictMock(clazz) : (mockType == EasyMockType.NICE ? this.createNiceMock(clazz) : this.createMock(clazz));
        FieldUtil.set((Field)field, (Object)test, mock);
        this.boundFields.add(field);
        if (annotation.register()) {
            container.register(mock, field.getName());
        }
    }

    public void unbindMockFields(Object test) {
        for (Field field : this.boundFields) {
            try {
                field.set(test, null);
            }
            catch (IllegalArgumentException e) {
                System.err.println(e);
            }
            catch (IllegalAccessException e) {
                System.err.println(e);
            }
        }
        this.boundFields.clear();
    }

    protected static EasyMockDelegator getEasyMockDelegator() {
        try {
            Class.forName("org.easymock.classextension.EasyMock");
            Class.forName("net.sf.cglib.proxy.Enhancer");
            return new ClassExtensionEacyMockDelegator();
        }
        catch (Throwable throwable) {
            return new DefaultEacyMockDelegator();
        }
    }
}

