/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.nested.html;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.struts.taglib.html.LinkTag;
import org.apache.struts.taglib.nested.NestedNameSupport;
import org.apache.struts.taglib.nested.NestedPropertyHelper;

public class NestedLinkTag
extends LinkTag
implements NestedNameSupport {
    private String origName = null;
    private String origProperty = null;
    private String origParamProperty = null;

    public int doStartTag() throws JspException {
        this.origName = super.getName();
        this.origProperty = super.getProperty();
        this.origParamProperty = super.getParamProperty();
        boolean doProperty = this.origProperty != null && this.origProperty.length() > 0;
        boolean doParam = this.origParamProperty != null && this.origParamProperty.length() > 0;
        HttpServletRequest request = (HttpServletRequest)((TagSupport)this).pageContext.getRequest();
        boolean hasName = this.getName() != null && this.getName().trim().length() > 0;
        String currentName = hasName ? this.getName() : NestedPropertyHelper.getCurrentName(request, this);
        super.setName(currentName);
        if (doProperty && !hasName) {
            super.setProperty(NestedPropertyHelper.getAdjustedProperty(request, this.origProperty));
        }
        if (doParam) {
            super.setName(null);
            super.setParamName(currentName);
            super.setParamProperty(NestedPropertyHelper.getAdjustedProperty(request, this.origParamProperty));
        }
        return super.doStartTag();
    }

    public int doEndTag() throws JspException {
        int i = super.doEndTag();
        this.setName(this.origName);
        this.setProperty(this.origProperty);
        this.setParamProperty(this.origParamProperty);
        return i;
    }

    public void release() {
        super.release();
        this.origName = null;
        this.origProperty = null;
        this.origParamProperty = null;
    }
}

