/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.argtype;

import org.seasar.extension.jdbc.gen.internal.argtype.ArgumentType;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumType<T extends Enum<T>>
implements ArgumentType<T> {
    protected Class<T> enumClass;

    public EnumType(Class<T> enumClass) {
        this.enumClass = enumClass;
    }

    @Override
    public T toObject(String value) {
        if (StringUtil.isEmpty((String)value)) {
            return null;
        }
        return Enum.valueOf(this.enumClass, value);
    }

    @Override
    public String toText(T value) {
        if (value == null) {
            return "";
        }
        return ((Enum)value).name();
    }
}

