/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.model;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.seasar.extension.jdbc.gen.internal.model.GeneratedModelSupport;
import org.seasar.extension.jdbc.gen.internal.model.SqlFileSupport;
import org.seasar.extension.jdbc.gen.model.SqlFileTestModel;
import org.seasar.extension.jdbc.gen.model.SqlFileTestModelFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlFileTestModelFactoryImpl
implements SqlFileTestModelFactory {
    protected String configPath;
    protected String jdbcManagerName;
    protected String packageName;
    protected String shortClassName;
    protected boolean useS2junit4;
    protected List<String> sqlFilePathList;
    protected SqlFileSupport sqlFileSupport;
    protected GeneratedModelSupport generatedModelSupport = new GeneratedModelSupport();

    public SqlFileTestModelFactoryImpl(File classpathDir, Set<File> sqlFileSet, String configPath, String jdbcManagerName, String packageName, String shortClassName, boolean useS2junit4) {
        this(classpathDir, sqlFileSet, configPath, jdbcManagerName, packageName, shortClassName, useS2junit4, new SqlFileSupport());
    }

    protected SqlFileTestModelFactoryImpl(File classpathDir, Set<File> sqlFileSet, String configPath, String jdbcManagerName, String packageName, String shortClassName, boolean useS2junit4, SqlFileSupport sqlFileSupport) {
        if (classpathDir == null) {
            throw new NullPointerException("classpathDir");
        }
        if (sqlFileSet == null) {
            throw new NullPointerException("sqlFileSet");
        }
        if (configPath == null) {
            throw new NullPointerException("configPath");
        }
        if (jdbcManagerName == null) {
            throw new NullPointerException("jdbcManagerName");
        }
        if (shortClassName == null) {
            throw new NullPointerException("shortClassName");
        }
        if (sqlFileSupport == null) {
            throw new NullPointerException("sqlFileSupport");
        }
        this.configPath = configPath;
        this.jdbcManagerName = jdbcManagerName;
        this.packageName = packageName;
        this.shortClassName = shortClassName;
        this.useS2junit4 = useS2junit4;
        this.sqlFileSupport = sqlFileSupport;
        this.sqlFilePathList = this.createSqlFilePathList(classpathDir, sqlFileSet);
    }

    protected List<String> createSqlFilePathList(File classpathDir, Set<File> sqlFileSet) {
        return this.sqlFileSupport.createSqlFilePathList(classpathDir, sqlFileSet);
    }

    @Override
    public SqlFileTestModel getSqlFileTestModel() {
        SqlFileTestModel model = new SqlFileTestModel();
        model.setConfigPath(this.configPath);
        model.setJdbcManagerName(this.jdbcManagerName);
        model.setPackageName(this.packageName);
        model.setShortClassName(this.shortClassName);
        model.setUseS2junit4(this.useS2junit4);
        for (String sqlFilePath : this.sqlFilePathList) {
            model.addSqlFilePath(sqlFilePath);
        }
        this.doGeneratedInfo(model);
        return model;
    }

    protected void doGeneratedInfo(SqlFileTestModel sqlFileTestModel) {
        this.generatedModelSupport.fillGeneratedInfo(this, sqlFileTestModel);
    }
}

