/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.extension.jdbc.util.DataSourceUtil;
import org.seasar.extension.jdbc.util.DatabaseMetaDataUtil;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.util.CaseInsensitiveSet;
import org.seasar.framework.util.ResultSetUtil;
import org.seasar.framework.util.StringUtil;

public class TableUtil {
    protected TableUtil() {
    }

    public static TableSet getTableSet(GenDialect dialect, DataSource dataSource) {
        return new TableSet(dialect, dataSource);
    }

    public static String buildCanonicalTableName(GenDialect dialect, String catalogName, String schemaName, String tableName) {
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName");
        }
        StringBuilder buf = new StringBuilder();
        if (catalogName != null) {
            buf.append(dialect.unquote(catalogName.toLowerCase()));
            buf.append(".");
            if (schemaName != null) {
                buf.append(dialect.unquote(schemaName.toLowerCase()));
            }
            buf.append(".");
        } else if (schemaName != null) {
            buf.append(dialect.unquote(schemaName.toLowerCase()));
            buf.append(".");
        }
        buf.append(dialect.unquote(tableName.toLowerCase()));
        return buf.toString();
    }

    public static String buildFullTableName(String catalogName, String schemaName, String tableName) {
        StringBuilder buf = new StringBuilder();
        if (!StringUtil.isEmpty((String)catalogName)) {
            buf.append(catalogName).append(".");
        }
        if (!StringUtil.isEmpty((String)schemaName)) {
            buf.append(schemaName).append(".");
        }
        return buf.append(tableName).toString();
    }

    public static String[] splitCanonicalTableName(String canonicalTableName) {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        int pos = 0;
        for (int i2 = 0; i2 < canonicalTableName.length(); ++i2) {
            char c = canonicalTableName.charAt(i2);
            if (c != '.') continue;
            list.add(canonicalTableName.substring(pos, i2));
            pos = i2 + 1;
        }
        list.add(canonicalTableName.substring(pos));
        String[] elements = new String[3];
        if (list.size() == 3) {
            for (i = 0; i < 3; ++i) {
                if (StringUtil.isEmpty((String)((String)list.get(i)))) continue;
                elements[i] = (String)list.get(i);
            }
        } else if (list.size() == 2) {
            for (i = 0; i < 2; ++i) {
                if (StringUtil.isEmpty((String)((String)list.get(i)))) continue;
                elements[i + 1] = (String)list.get(i);
            }
        } else if (list.size() == 1) {
            elements[2] = (String)list.get(0);
        } else {
            throw new IllegalArgumentException(canonicalTableName);
        }
        return elements;
    }

    protected static class Qualifier {
        protected String catalogName;
        protected String schemaName;

        public Qualifier(String catalogName, String schemaName) {
            if (catalogName != null) {
                this.catalogName = catalogName.toLowerCase();
            }
            if (schemaName != null) {
                this.schemaName = schemaName.toLowerCase();
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.catalogName == null ? 0 : this.catalogName.hashCode());
            result = 31 * result + (this.schemaName == null ? 0 : this.schemaName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Qualifier other = (Qualifier)obj;
            if (this.catalogName == null ? other.catalogName != null : !this.catalogName.equals(other.catalogName)) {
                return false;
            }
            return !(this.schemaName == null ? other.schemaName != null : !this.schemaName.equals(other.schemaName));
        }
    }

    public static class TableSet {
        protected GenDialect dialect;
        protected DataSource dataSource;
        protected String defaultSchemaName;
        protected Map<Qualifier, CaseInsensitiveSet> tableNamesMap = new HashMap<Qualifier, CaseInsensitiveSet>();

        protected TableSet(GenDialect dialect, DataSource dataSource) {
            if (dialect == null) {
                throw new NullPointerException("dialect");
            }
            if (dataSource == null) {
                throw new NullPointerException("dataSource");
            }
            this.dialect = dialect;
            this.dataSource = dataSource;
            this.defaultSchemaName = this.getDefaultSchemaName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String getDefaultSchemaName() {
            Connection connection = DataSourceUtil.getConnection((DataSource)this.dataSource);
            try {
                DatabaseMetaData metaData = ConnectionUtil.getMetaData((Connection)connection);
                String userName = DatabaseMetaDataUtil.getUserName((DatabaseMetaData)metaData);
                String string = this.dialect.getDefaultSchemaName(userName);
                return string;
            }
            finally {
                ConnectionUtil.close((Connection)connection);
            }
        }

        public boolean exists(String catalogName, String schemaName, String tableName) {
            schemaName = schemaName != null ? schemaName : this.defaultSchemaName;
            CaseInsensitiveSet tableNames = this.getTableNames(catalogName, schemaName);
            return tableNames.contains((Object)tableName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CaseInsensitiveSet getTableNames(String catalogName, String schemaName) {
            Qualifier qualifier = new Qualifier(catalogName, schemaName);
            if (this.tableNamesMap.containsKey(qualifier)) {
                return this.tableNamesMap.get(qualifier);
            }
            Connection connection = DataSourceUtil.getConnection((DataSource)this.dataSource);
            try {
                CaseInsensitiveSet caseInsensitiveSet;
                DatabaseMetaData metaData = ConnectionUtil.getMetaData((Connection)connection);
                ResultSet rs = metaData.getTables(catalogName, schemaName, null, new String[]{"TABLE"});
                try {
                    CaseInsensitiveSet tableNames = new CaseInsensitiveSet();
                    while (rs.next()) {
                        tableNames.add((Object)rs.getString("TABLE_NAME"));
                    }
                    this.tableNamesMap.put(qualifier, tableNames);
                    caseInsensitiveSet = tableNames;
                }
                catch (Throwable throwable) {
                    try {
                        ResultSetUtil.close((ResultSet)rs);
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new SQLRuntimeException(e);
                    }
                }
                ResultSetUtil.close((ResultSet)rs);
                return caseInsensitiveSet;
            }
            finally {
                ConnectionUtil.close((Connection)connection);
            }
        }
    }
}

