/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.validator;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.validator.ValidatorPlugIn;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.struts.validator.S2ValidatorResources;
import org.xml.sax.SAXException;

public class S2ValidatorPlugIn
extends ValidatorPlugIn {
    protected static Log log = LogFactory.getLog(S2ValidatorPlugIn.class);
    protected static final String RESOURCE_DELIM = ",";
    protected ActionServlet actionServlet = null;
    protected ModuleConfig moduleConfig;

    public void init(ActionServlet actionServlet, ModuleConfig moduleConfig) throws ServletException {
        this.actionServlet = actionServlet;
        this.moduleConfig = moduleConfig;
        super.init(actionServlet, moduleConfig);
    }

    protected void initResources() throws IOException, ServletException {
        String pathnames = this.getPathnames();
        if (pathnames == null || pathnames.length() <= 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(pathnames, RESOURCE_DELIM);
        ArrayList<BufferedInputStream> streamList = new ArrayList<BufferedInputStream>();
        try {
            while (st.hasMoreTokens()) {
                InputStream input;
                String validatorRules = st.nextToken().trim();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Loading validation rules file from '" + validatorRules + "'"));
                }
                if ((input = this.actionServlet.getServletContext().getResourceAsStream(validatorRules)) == null) {
                    input = ((Object)((Object)this)).getClass().getResourceAsStream(validatorRules);
                }
                if (input != null) {
                    BufferedInputStream bis = new BufferedInputStream(input);
                    streamList.add(bis);
                    continue;
                }
                throw new ServletException("Skipping validation rules file from '" + validatorRules + "'.  No stream could be opened.");
            }
            int streamSize = streamList.size();
            InputStream[] streamArray = streamList.toArray(new InputStream[streamSize]);
            this.resources = new S2ValidatorResources(streamArray);
        }
        catch (SAXException sex) {
            log.error((Object)"Skipping all validation", (Throwable)sex);
            throw new ServletException((Throwable)sex);
        }
        finally {
            Iterator streamIterator = streamList.iterator();
            while (streamIterator.hasNext()) {
                InputStreamUtil.close((InputStream)((InputStream)streamIterator.next()));
            }
        }
    }
}

