/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.validator;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.ValidatorResources;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.container.hotdeploy.HotdeployUtil;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DisposableUtil;
import org.xml.sax.SAXException;

public class S2ValidatorResources
extends ValidatorResources
implements Disposable {
    private static final long serialVersionUID = 1L;
    protected static final String[] REGISTRATIONS = new String[]{"-//Apache Software Foundation//DTD Commons Validator Rules Configuration 1.0//EN", "/org/apache/commons/validator/resources/validator_1_0.dtd", "-//Apache Software Foundation//DTD Commons Validator Rules Configuration 1.0.1//EN", "/org/apache/commons/validator/resources/validator_1_0_1.dtd", "-//Apache Software Foundation//DTD Commons Validator Rules Configuration 1.1//EN", "/org/apache/commons/validator/resources/validator_1_1.dtd", "-//Apache Software Foundation//DTD Commons Validator Rules Configuration 1.1.3//EN", "/org/apache/commons/validator/resources/validator_1_1_3.dtd", "-//Apache Software Foundation//DTD Commons Validator Rules Configuration 1.2.0//EN", "/org/apache/commons/validator/resources/validator_1_2_0.dtd", "-//Apache Software Foundation//DTD Commons Validator Rules Configuration 1.3.0//EN", "/org/apache/commons/validator/resources/validator_1_3_0.dtd"};
    protected volatile boolean initialized = false;
    protected Map<String, Form> forms = new HashMap<String, Form>();

    public S2ValidatorResources() {
    }

    public S2ValidatorResources(InputStream[] streams) throws IOException, SAXException {
        int i;
        URL rulesUrl = ValidatorResources.class.getResource("digester-rules.xml");
        Digester digester = DigesterLoader.createDigester((URL)rulesUrl);
        digester.setNamespaceAware(true);
        digester.setValidating(true);
        digester.setUseContextClassLoader(true);
        for (i = 0; i < REGISTRATIONS.length; i += 2) {
            URL url = ValidatorResources.class.getResource(REGISTRATIONS[i + 1]);
            if (url == null) continue;
            digester.register(REGISTRATIONS[i], url.toString());
        }
        for (i = 0; i < streams.length; ++i) {
            digester.push((Object)this);
            digester.parse(streams[i]);
        }
        this.initialize();
    }

    public void initialize() {
        DisposableUtil.add((Disposable)this);
        this.initialized = true;
    }

    public void dispose() {
        this.forms.clear();
        this.initialized = false;
    }

    public Form getForm(Locale locale, String formKey) {
        Form form;
        if (!this.initialized) {
            this.initialize();
        }
        if ((form = this.forms.get(formKey)) == null && HotdeployUtil.isHotdeploy() && formKey.endsWith("Form")) {
            SingletonS2ContainerFactory.getContainer().getComponentDef((Object)formKey.substring(0, formKey.length() - 4));
            form = this.forms.get(formKey);
        }
        return form;
    }

    public void addForm(Form form) {
        this.forms.put(form.getName(), form);
    }

    public String getConstant(String name) {
        return (String)this.hConstants.get((Object)name);
    }
}

