package net.waltzstudio.montecarlo.dao.ticketUnread;

import static org.seasar.extension.jdbc.operation.Operations.*;
import java.util.List;
import net.waltzstudio.base.framework.dao.AuditDao;
import net.waltzstudio.base.framework.types.DeleteFlg;
import net.waltzstudio.montecarlo.entity.ticketUnread.TicketUnread;
import net.waltzstudio.montecarlo.entity.ticketUnread.TicketUnreadName;

/**
 * チケット未読DaoBase
 */
public abstract class TicketUnreadDaoBase extends AuditDao<TicketUnread> implements TicketUnreadName {

	public TicketUnread findById(Long id) {
		return select().id(id).where(eq($DELETE_FLG, DeleteFlg.NORMAL)).getSingleResult();
	}

	public List<TicketUnread> findAllOrderById() {
		return select().where(eq($DELETE_FLG, DeleteFlg.NORMAL)).orderBy(asc($ID)).getResultList();
	}

}
