package net.waltzstudio.montecarlo.action.secure;

import static net.waltzstudio.base.framework.util.SyntaxSugar.*;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.seasar.framework.util.StringUtil;
import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;
import net.waltzstudio.base.framework.util.BaseUtil;
import net.waltzstudio.montecarlo.form.LoginForm;
import net.waltzstudio.montecarlo.object.Global;
import net.waltzstudio.montecarlo.service.LoginService;

/**
 * 認証Action
 */
public class IndexAction {
	/** ログインForm */
	@Resource
	@ActionForm
	protected LoginForm loginForm;

	/** セッション */
	@Resource
	protected Map<String, Object> sessionScope;
	/** ログインService */
	@Resource
	protected LoginService loginService;

	/** HTTPリクエスト */
	@Resource
	protected HttpServletRequest request;
	/** HTTPセッション */
	@Resource
	protected HttpSession session;

	/**
	 * デフォルトページ
	 *
	 * @return ログイン
	 */
	@Execute(validator = false)
	public String index() {
		return "/secure/login?redirect=true";
	}

	/**
	 * ログイン
	 *
	 * @return ログイン画面
	 */
	@Execute(validator = false)
	public String login() {
		return "login.jsp";
	}

	/**
	 * ログイン処理
	 *
	 * @return ログイン失敗⇒ログイン / ログイン成功⇒ホーム
	 */
	@Execute(input = "/secure/login?redirect=true")
	public String confirm() {
		String redirectUrl = S(sessionScope.get(Global.SessionInfo.REDIRECT_URL));
		if (loginService.login(loginForm)) {
			if (!StringUtil.isEmpty(redirectUrl)) {
				return S(redirectUrl, "?redirect=true");
			} else {
				return "/?redirect=true";
			}
		}
		session.invalidate();
		session = request.getSession(true);
		session.setAttribute(Global.SessionInfo.REDIRECT_URL, redirectUrl);
		BaseUtil.addError("errors.login");
		return "/secure?redirect=true";
	}

	/**
	 * ログアウト
	 *
	 * @return ログイン
	 */
	@Execute(validator = false)
	public String logout() {
		session.invalidate();
		return "/secure?redirect=true";
	}

}
