package net.waltzstudio.montecarlo.dao.account;

import static net.waltzstudio.base.framework.util.SyntaxSugar.*;
import static org.seasar.extension.jdbc.operation.Operations.*;
import java.util.List;
import net.waltzstudio.base.framework.types.DeleteFlg;
import net.waltzstudio.montecarlo.entity.account.Account;

/**
 * アカウントDao
 */
public abstract class AccountDao extends AccountDaoBase {

	/**
	 * ログインパスワードによるSelect
	 *
	 * @param login ログイン
	 * @param password パスワード
	 * @return アカウントEntity
	 */
	public Account findByLoginPassword(String login, String password) {
		return select().where(eq($LOGIN, login), eq($PASSWORD, password), eq($DELETE_FLG, DeleteFlg.NORMAL)).getSingleResult();
	}

	public List<Account> findByProjectId(Long projectId) {
		String sql = SB(true, " ", //
				"  SELECT *                            ", //
				"    FROM account a                    ", //
				"   WHERE a.delete_flg = '0'           ", //
				"     AND exists (                     ", //
				"          SELECT 1                    ", //
				"            FROM account_project ap   ", //
				"           WHERE ap.delete_flg = '0'  ", //
				"             AND ap.project_id = ?    ", //
				"             AND ap.account_id = a.id ", //
				"        )                             ", //
				"ORDER BY id                           ");
		return jdbcManager.selectBySql(Account.class, sql, projectId).getResultList();
	}

}
