package net.waltzstudio.montecarlo.object;

import static net.waltzstudio.base.framework.util.SyntaxSugar.*;
import javax.annotation.Resource;
import org.seasar.framework.log.Logger;
import net.waltzstudio.montecarlo.service.batch.BatchControlService;
import net.waltzstudio.montecarlo.types.BatchStatus;

/**
 * バッチ抽象クラス
 */
public abstract class Batch extends Thread {
	/** logger */
	protected Logger logger = Logger.getLogger(Batch.class);

	/** バッチステータス */
	public BatchStatus status = BatchStatus.STANDBY;

	/** バッチ管理Service */
	@Resource
	protected BatchControlService batchControlService;

	@Override
	public void run() {
		try {
			logger.info(S(getBatchName(), "処理開始"));
			status = BatchStatus.ACTIVE;
			main();
		} catch (InterruptedException e) {
		} catch (Throwable e) {
			logger.fatal(S(getBatchName(), "で予期せぬエラーが発生しました。"), e);
		} finally {
			logger.info(S(getBatchName(), "処理終了"));
			batchControlService.remove(getBatchId());
			status = BatchStatus.STANDBY;
		}
	}

	/**
	 * バッチIDを返す
	 *
	 * @return バッチID
	 */
	public abstract String getBatchId();

	/**
	 * バッチ名称を返す
	 *
	 * @return バッチ名称
	 */
	public abstract String getBatchName();

	/**
	 * メイン処理
	 */
	public abstract void main() throws Exception;

}
