// 
// AString.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _AString_INCLUDED_
#define _AString_INCLUDED_
#include "Buffer.h"

namespace scpl{

	/**
		ANSI 𑀍삷NXłB
	**/
	class AString{
		typedef AString			self;
		typedef Buffer<char>	buffer;
		typedef char*			ptr;
		typedef const char*		cptr;
		typedef char&			ind;
		typedef const char&		cind;

		// ƗpB
		self& _insertChar(char c,ulong index);
		self& _insertStr(cstr text,long count,ulong index);
		self& _insertNum(long l,ulong index,long radix);
		self& _insertUNum(ulong l,ulong index,long radix);
		buffer* getBuf(){return &_Text;}

	public:
		/**
			̕쐬܂B
		**/
		AString():_UseCount(0){}

		/**
			̕쐬܂B
			炩ߎw肵mۂ܂B
			[arg]
			bufCount : mۂ镶B
			[exc]
			std::bad_alloc	: mۂ̈悪B
		**/
		AString(ulong bufCount):_Text(bufCount,true),_UseCount(0){}

		/**
			񂩂쐬܂B
			[arg]
			s		: B
			count	: s ̕B -1 w肷ƑSĎg܂B
			[exc]
			std::bad_alloc	: mۂ̈悪B
		**/
		AString(cstr s,long count=-1):_UseCount(0){copy(s,count);}

		/**
			Rs[RXgN^B
			[arg]
			t	: Rs[镶B
			[exc]
			std::bad_alloc	: mۂ̈悪B
		**/
		AString(const self& t){copy(t.get());}

		/**
			Ԃ܂B
			[return]
			B
		**/
		operator cstr()const{return empty()?NULL:_Text.get();}
		/**
			񂪋󂩂Ԃ܂B
			[return]
			ĂȂꍇ true AłȂꍇ false B
		**/
		bool operator!()const{return _UseCount==0;}

		/**
			p̍ŏ̈ʒu|C^Ԃ܂B
			[return]
			z̍ŏ̈ʒu|C^B
			f[^݂ȂƂ NULL Ԃ܂B
		**/
		ptr begin()const{return empty()?NULL:_Text.get();}
		/**
			p̍Ō̈ʒu|C^Ԃ܂B
			[return]
			z̍Ō̈ʒu|C^B
			̈ʒüOLĂI[łB
			f[^݂ȂƂ NULL Ԃ܂B
		**/
		ptr end()const{return empty()?NULL:(_Text.get()+_UseCount);}
		/**
			tp̍ŏ̈ʒu|C^Ԃ܂B
			[return]
			tz̍ŏ̈ʒu|C^B
			f[^݂ȂƂ NULL Ԃ܂B
		**/
		ptr rbegin()const{return empty()?NULL:(_Text.get()+_UseCount-1);}
		/**
			tp̍Ō̈ʒu|C^Ԃ܂B
			[return]
			tz̍Ō̈ʒu|C^B
			̈ʒüオLĂI[łB
			f[^݂ȂƂ NULL Ԃ܂B
		**/
		ptr rend()const{return empty()?NULL:(_Text.get()-1);}

		/**
			Ԃ܂B
			[return]
			LĂ镶̕B
			[note]
			Ԃ镶ɂ NULL ͊܂݂܂B
		**/
		ulong count()const{return _UseCount;}
		/**
			mۂĂ镶Ԃ܂B
			[return]
			mۂĂ镶B
			[note]
			Ԃ镶ɂ NULL ܂݂܂B
		**/
		ulong capacity()const{return _Text.count();}
		/**
			񂪋󂩂Ԃ܂B
			ĂȂꍇ true AłȂꍇ false B
		**/
		bool empty()const{return _UseCount == 0;}

		/**
			܂B
			[arg]
			s	: 镶B
			[return]
			g̃CX^XԂ܂B
			[exc]
			std::bad_alloc	: s߂̃mۂłȂB
		**/
		self& operator=(cstr s){copy(s);return *this;}
		/**
			l𕶎ɕϊđ܂B
			[arg]
			l	: 鐔lB
			[return]
			g̃CX^XԂ܂B
			[exc]
			std::bad_alloc	: s߂̃mۂłȂB
		**/
		self& operator=(long l){clear(true);lastInNum(l);return *this;}

		/**
			ɒǉ܂B
			[arg]
			s	: ǉ镶B
			[return]
			g̃CX^XԂ܂B
			[exc]
			std::bad_alloc	: s߂̃mۂłȂB
		**/
		self& operator+=(cstr s){return lastInStr(s);}
		/**
			l𕶎ɕϊĒǉ܂B
			[arg]
			l	: ǉ鐔lB
			[return]
			g̃CX^XԂ܂B
			[exc]
			std::bad_alloc	: s߂̃mۂłȂB
		**/
		self& operator+=(long l){return lastInNum(l);}

		/**
			A܂B
			[arg]
			s	: A镶B
			[return]
			g̃CX^XԂ܂B
			[exc]
			std::bad_alloc	: s߂̃mۂłȂB
		**/
		self operator+(self& s)const{return strcat(get(),s);}

		/**
			w肵ʒuɂ镶Ԃ܂B
			[arg]
			index	: 擪̕ʒuB
			[return]
			w肵ʒu̕Ԃ܂B
		**/
		ind at(ulong index){return _Text.get()[index];}
		cind at(ulong index)const{return _Text.get()[index];}
		/**
			擪ɂ镶Ԃ܂B
			[return]
			擪̕Ԃ܂B
		**/
		ind atFirst(){return at(0);}
		cind atFirst()const{return at(0);}
		/**
			I[ɂ镶Ԃ܂B
			[return]
			I[̕Ԃ܂B
		**/
		ind atLast(){return at(_UseCount-1);}
		cind atLast()const{return at(_UseCount-1);}

		/**
			Ԃ܂B
			[return]
			B
		**/
		cstr get()const{return empty()?NULL:_Text.get();}

		/**
			w肵ʒuɑ}܂B
			[arg]
			c		: }镶B
			index	: }ʒuB
			[return]
			g̃CX^XԂ܂B
			[exc]
			std::bad_alloc	: s߂̃mۂłȂB
		**/
		self& insertChar(char c,ulong index){return _insertChar(c,index);}
		/**
			擪ɑ}܂B
			[arg]
			c	: }镶B
			[exc]
			std::bad_alloc	: s߂̃mۂłȂB
		**/
		self& firstInChar(char c){return _insertChar(c,0);}
		/**
			I[ɒǉ܂B
			[arg]
			c	: ǉ镶B
			[exc]
			std::bad_alloc	: s߂̃mۂłȂB
		**/
		self& lastInChar(char c){return _insertChar(c,_UseCount);}

		/**
			w肵ʒuɑ}܂B
			[arg]
			text	: }镶B
			count	: }镶̕B -1 w肷ƂׂĂ}܂B
			index	: }ʒuB
			[return]
			g̃CX^XԂ܂B
			[exc]
			std::bad_alloc	: s߂̃mۂłȂB
		**/
		self& insertStr(cstr text,long count,ulong index){return _insertStr(text,count,index);}
		/**
			擪ɑ}܂B
			[arg]
			text	: }镶B
			count	: }镶̕B -1 w肷ƂׂĂ}܂B
			[return]
			g̃CX^XԂ܂B
			[exc]
			std::bad_alloc	: s߂̃mۂłȂB
		**/
		self& firstInStr(cstr text,long count=-1){return _insertStr(text,count,0);}
		/**
			Ōɒǉ܂B
			[arg]
			text	: ǉ镶B
			count	: }镶̕B -1 w肷ƂׂĂ}܂B
			[return]
			g̃CX^XԂ܂B
			[exc]
			std::bad_alloc	: s߂̃mۂłȂB
		**/
		self& lastInStr(cstr text,long count=-1){return _insertStr(text,count,_UseCount);}

		/**
			l𕶎ɕϊAw肵ʒuɑ}܂B
			[arg]
			l		: }鐔lB
			index	: }ʒuB
			radix	: B2 ` 36 ͈̔͂wB
			[return]
			g̃CX^XԂ܂B
			[exc]
			std::bad_alloc	: s߂̃mۂłȂB
		**/
		self& insertNum(long l,ulong index,long radix=10){return _insertNum(l,index,radix);}
		/**
			l𕶎ɕϊA擪ɑ}܂B
			[arg]
			l		: }鐔lB
			radix	: B2 ` 36 ͈̔͂wB
			[return]
			g̃CX^XԂ܂B
			[exc]
			std::bad_alloc	: s߂̃mۂłȂB
		**/
		self& firstInNum(long l,long radix=10){return _insertNum(l,0,radix);}
		/**
			l𕶎ɕϊAŌɒǉ܂B
			[arg]
			l		: }鐔lB
			radix	: B2 ` 36 ͈̔͂wB
			[return]
			g̃CX^XԂ܂B
			[exc]
			std::bad_alloc	: s߂̃mۂłȂB
		**/
		self& lastInNum(long l,long radix=10){return _insertNum(l,_UseCount,radix);}

		/**
			l𕶎ɕϊAw肵ʒuɑ}܂B
			[arg]
			l		: }鐔lB
			index	: }ʒuB
			radix	: B2 ` 36 ͈̔͂wB
			[return]
			g̃CX^XԂ܂B
			[exc]
			std::bad_alloc		: s߂̃mۂłȂB
		**/
		self& insertUNum(ulong l,ulong index,long radix=10){return _insertUNum(l,index,radix);}
		/**
			l𕶎ɕϊA擪ɑ}܂B
			[arg]
			l		: }鐔lB
			radix	: B2 ` 36 ͈̔͂wB
			[return]
			g̃CX^XԂ܂B
			[exc]
			std::bad_alloc	: s߂̃mۂłȂB
		**/
		self& firstInUNum(ulong l,long radix=10){return _insertUNum(l,0,radix);}
		/**
			l𕶎ɕϊAŌɒǉ܂B
			[arg]
			l		: }鐔lB
			radix	: B2 ` 36 ͈̔͂wB
			[return]
			g̃CX^XԂ܂B
			[exc]
			std::bad_alloc	: s߂̃mۂłȂB
		**/
		self& lastInUNum(ulong l,long radix=10){return _insertUNum(l,_UseCount,radix);}

		/**
			w肵ʒuɑ}܂B
			[arg]
			text	: }镶B
			index	: }ʒuB
			[return]
			g̃CX^XԂ܂B
			[exc]
			std::bad_alloc		: s߂̃mۂłȂB
		**/
		self& insert(const self& text,ulong index){return insertStr(text,text.count(),index);}
		/**
			擪ɑ}܂B
			[arg]
			text	: }镶B
			[exc]
			std::bad_alloc	: s߂̃mۂłȂB
		**/
		self& firstIn(const self& text){return firstInStr(text,text.count());}
		/**
			Ōɒǉ܂B
			[arg]
			text	: ǉ镶B
			[return]
			g̃CX^XԂ܂B
			[exc]
			std::bad_alloc	: s߂̃mۂłȂB
		**/
		self& lastIn(const self& text){return lastInStr(text,text.count());}

		/**
			w肵ʒu̕폜܂B
			[arg]
			index - 폜ʒuB
		**/
		void removeAt(ulong index);
		/**
			擪̕폜܂B
		**/
		void firstOut(){removeAt(0);}
		/**
			Ō̕폜܂B
		**/
		void lastOut(){removeAt(count() - 1);}

		/**
			w肵͈͂̕폜܂B
			[arg]
			indexL - 폜ŏ̈ʒuB
			indexR - 폜Ō̈ʒuB
		**/
		void erage(ulong indexL,ulong indexR);
		/**
			擪w肵폜܂B
			[arg]
			c	: 폜镶B
		**/
		void firstOut(ulong c){erage(0,c);}
		/**
			Ōw肵폜܂B
			[arg]
			c	: 폜镶B
		**/
		void lastOut(ulong c){erage(count() - c,count());}

		/**
			NA܂B
			[arg]
			noClearCapacity	: Capacity ̈̂܂܂ɂ邩ǂB
		**/
		void clear(bool noClearCapacity=true);

		/**
			񂩂Rs[܂B
			[arg]
			s     - B
			count - s ̕B -1 w肷ƑSĎg܂B
			[exc]
			std::bad_alloc	: s߂̃mۂłȂB
		**/
		void copy(cstr s,long count=-1);
		/**
			Rs[܂B
			[arg]
			s	: Rs[镶B
			[exc]
			std::bad_alloc	: s߂̃mۂłȂB
		**/
		void copy(const self& s){if(&s != this) copy(s.get());}

		/**
			ւ܂B
			[arg]
			s	: ւ镶B
		**/
		void swap(self& t){
			_Text.swap(t._Text);
			scpl::swap(_UseCount,t._UseCount);
		}

		/**
			񂪈vĂ邩Ԃ܂B
			[arg]
			s	: r镶B
			[return]
			vĂ true ԂAłȂꍇ false Ԃ܂B
		**/
		bool equals(cstr s)const;

		/**
			w肵݂邩𒲂ׂ܂B
			[arg]
			c		: ׂ镶B
			start	: JnʒuB
			[return]
			ŏɌʒuԂ܂B
			Ȃꍇ -1 Ԃ܂B
		**/
		long find(char c,ulong start=0)const;

		/**
			w肵񂪑݂邩𒲂ׂ܂B
			[arg]
			c		: ׂ镶B
			start	: JnʒuB
			[return]
			ŏɌʒuԂ܂B
			Ȃꍇ -1 Ԃ܂B
		**/
		long find(cstr c,ulong start=0)const;

		/**
			̔ppSďɂ܂B
		**/
		void toLower();
		/**
			̔ppSđ啶ɂ܂B
		**/
		void toUpper();

		/**
			mۂĂw肵܂B
			[arg]
			bufCount	: mۂĂB
			[exc]
			std::bad_alloc	: mۂ镶̗̈mۂłȂB
		**/
		void adjust(ulong bufCount=0){_Text.aResize(_UseCount + bufCount + 1,true);}

		/**
			̕AԂ܂B
			[arg]
			a	: A鍶̕B
			b	: AE̕B
			[exc]
			std::bad_alloc	: mۂ镶̗̈mۂłȂB
		**/
		static AString strcat(cstr a,cstr b);

	private:
		buffer _Text;
		ulong _UseCount;

	};

} // namespace scpl

inline bool operator==(const scpl::AString& l,const scpl::AString& r){return l.equals(r);}
inline bool operator==(scpl::cstr l,const scpl::AString& r){return r.equals(l);}
inline bool operator==(const scpl::AString& l,scpl::cstr r){return l.equals(r);}
inline bool operator!=(const scpl::AString& l,const scpl::AString& r){return !l.equals(r);}
inline bool operator!=(scpl::cstr l,const scpl::AString& r){return !r.equals(l);}
inline bool operator!=(const scpl::AString& l,scpl::cstr r){return !l.equals(r);}

inline scpl::AString operator+(const scpl::AString& l,const scpl::AString& r){return scpl::AString::strcat(l,r);}
inline scpl::AString operator+(scpl::cstr l,const scpl::AString& r){return scpl::AString::strcat(l,r);}
inline scpl::AString operator+(const scpl::AString& l,scpl::cstr r){return scpl::AString::strcat(l,r);}

#endif