// 
// Thread.h
// 
// Copyright(C) 2007 Mitsunagi

#ifndef _Thread_INCLUDED_
#define _Thread_INCLUDED_
#include "scpl.h"

namespace scpl{

	class Thread;

	/**
		W C Cu _beginthread ֐găXbh쐬܂B
		[arg]
			func	: Xbh֐B
			param	: Xbh֐ɓnf[^B
			stack	: X^bNeʁB0 w肷Ɗ̃TCYgp܂B
		[return]
		ɐꍇ̓XbhNX𐶐ĕԂAłȂꍇ NULL Ԃ܂B
		[exc]
		std::bad_alloc	: ɕKvȗ̈mۂłȂB
	**/
	Thread* beginThread(void (__cdecl*func)(void*),vptr param=NULL,ulong stack=0);
	/**
		W C Cu _beginthreadEx ֐găXbh쐬܂B
		[arg]
			func	: Xbh֐B
			param	: Xbh֐ɓnf[^B
			stack	: X^bNeʁB0 w肷Ɗ̃TCYgp܂B
		[return]
		ɐꍇ̓XbhNX𐶐ĕԂAłȂꍇ NULL Ԃ܂B
		[exc]
		std::bad_alloc	: ɕKvȗ̈mۂłȂB
	**/
	Thread* beginThreadEx(uint (__stdcall*func)(void*),vptr param=NULL,ulong stack=0);
	/**
		Windows API  CreateThread ֐găXbh쐬܂B
		[arg]
			func	: Xbh֐B
			param	: Xbh֐ɓnf[^B
			stack	: X^bNeʁB0 w肷Ɗ̃TCYgp܂B
		[return]
		ɐꍇ̓XbhNX𐶐ĕԂAłȂꍇ NULL Ԃ܂B
		[exc]
		std::bad_alloc	: ɕKvȗ̈mۂłȂB
	**/
	Thread* createThread(ulong (__stdcall*func)(void*),vptr param=NULL,ulong stack=0);

	/**
		Windows ̃Xbh𐶐EǗNXłB
	**/
	class Thread{
		friend Thread* beginThread(void (__cdecl*)(void*),vptr,ulong);
		friend Thread* beginThreadEx(uint (__stdcall*)(void*),vptr,ulong);
		friend Thread* createThread(ulong (__stdcall*)(void*),vptr,ulong);

		Thread(){}

		void set(vptr thread,bool mc=true){_Thread = thread;_MustClose = mc;}

	public:
		/**
			setPriority ֐ŎgpD惌xB
		**/
		enum SETPRIORITY_TYPE{
			SETPRI_IDLE			= 0,	// AChԁiŒj
			SETPRI_NORMAL		= 1,	// W
			SETPRI_HIGH			= 2,	// 
			SETPRI_REALTIME		= 3,	// A^Ciōj
			SETPRI_BELOW_NORMAL	= 4,	// WႢ
			SETPRI_ABOVE_NORMAL	= 5,	// W荂
		};
		/**
			getPriority ֐ŎgpD惌xB
		**/
		enum GETPRIORITY_TYPE{
			GETPRI_IDLE			= 0,	// AChԁiŒj
			GETPRI_LOWEST		= 1,	// Ⴂ
			GETPRI_BELOW_NORMAL	= 2,	// WႢ
			GETPRI_NORMAL		= 3,	// W
			GETPRI_ABOVE_NORMAL	= 4,	// W荂
			GETPRI_HIGHEST		= 5,	// 
			GETPRI_REALTIME		= 6,	// A^Ciōj
		};

		/**
			Xbh쒆Ԃ܂B
			[return]
			Xbh쒆̏ꍇ true AłȂꍇ false Ԃ܂B
		**/
		operator bool()const{return isAlive();}
		/**
			XbhIĂ邩Ԃ܂B
			[return]
			XbhIĂꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator!()const{return !isAlive();}

		/**
			fXgN^B
			LĂXbh΋I܂B
		**/
		~Thread();

		/**
			XbhIɕԂꂽl擾܂B
			[arg]
			code	: l󂯎ϐւ̃AhXB
			[return]
			擾ɐꍇ 0 ԂA code ɒlZbg܂B
			Xbh쒆̏ꍇ ̒lԂA
			̖̑Ŏsꍇ͕̒lԂ܂B
			擾ɎsꍇA code ͕ύX܂B
			܂A beginThread ֐ō쐬Xbh̏ꍇA
			߂l擾邱ƂoȂ߁As킸 -1 Ԃ܂B
			[note]
			Xbh̖߂l 259 ̏ꍇA
			 Win API ł̃XbhIĂȂƂG[R[ĥ߁A
			̊֐ł͐̒lԂA code ͕ύX܂B
		**/
		int getExitCode(ulong* code);

		/**
			TXyhw񐔂Ԃ܂B
			[return]
			TXyhw񐔁B
		**/
		ulong getSuspendCount()const{return _SuspendCount;}
		/**
			Xbh̃nhԂ܂B
			[return]
			Xbh̃nhB
		**/
		vptr getHandle()const{return _Thread;}

		/**
			XbhTXyhiꎞ~j܂B
			[return]
			ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool suspend();
		/**
			XbhV[iĊJj܂B
			TXyh񐔂 0 ɂȂȂĊJ܂B
			[return]
			ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool resume();

		/**
			Xbh쒆Ԃ܂B
			[return]
			Xbh쒆̏ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool isAlive()const;

		/**
			Xbh̗Dx擾܂B
			[arg]
			priority	: Xbh̗Dx擾ϐւ̃|C^B
			[return]
			ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool getPriority(GETPRIORITY_TYPE* priority);
		/**
			Xbh̗Dxݒ肵܂B
			[arg]
			priority	: Xbh̗DxB
			[return]
			ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool setPriority(SETPRIORITY_TYPE priority);

		/**
			XbhI܂B
			[arg]
			code	: IR[hB
			[note]
			̊֐̓XbhI܂B
			̂߁Ǎ̓삪sɂȂ\܂B
		**/
		void terminate(ulong code);
		/**
			XbhI܂ő҂܂B
			[note]
			̊֐̓XbhI܂Ŋ֐o܂B
		**/
		void exitWait();
		/**
			̊֐ĂяoXbhI܂B
			[arg]
			code	: IR[hB
		**/
		static void exit(ulong code);

		/**
			̃Xbh֖Iɏn܂B
		**/
		static bool yield();

	private:
		vptr	_Thread;
		bool	_MustClose;
		ulong	_SuspendCount;

	};

} // namespace scpl
#endif // _Thread_INCLUDED_