// 
// File.cpp
// 
// Copylight(C) 2007 Ó

#include "stdafx.h"
#include "../scpl/File.h"
#include "../scpl/flag.h"
#include <stdlib.h>
namespace scpl{

// File //

	void File::gen_fmode(ulong mode,char(&rmode)[4]){
		bool plus = isFragOnBit(mode,2);
		bool bin = isFragOnBit(mode,3);
		byte pos=1;
		switch(mode&3){
			case 1:rmode[0] = 'r';break;
			case 2:rmode[0] = 'w';break;
			case 3:rmode[0] = 'a';break;
		}
		if(plus) rmode[pos++] = '+';
		rmode[pos++] = bin?'b':'t';
		rmode[pos] = '\0';
	}
	void File::gen_fmode(ulong mode,wchar_t(&rmode)[4]){
		bool plus = isFragOnBit(mode,2);
		bool bin = isFragOnBit(mode,3);
		byte pos=1;
		switch(mode&3){
			case 1:rmode[0] = L'r';break;
			case 2:rmode[0] = L'w';break;
			case 3:rmode[0] = L'a';break;
		}
		if(plus) rmode[pos++] = L'+';
		rmode[pos++] = bin?L'b':L't';
		rmode[pos] = L'\0';
	}

	bool File::flush(){return (fflush(_Fp) != EOF);}

// AFileReader //

	bool AFileReader::getStr(str buf,int size,bool useReturnChar){
		if(fgets(buf,size,_Fp) != NULL){
			if(!useReturnChar) buf[strlen(buf)-1] = '\0';
			return true;
		}
		return false;
	}
	bool AFileReader::getWStr(wstr buf,int size,bool useReturnChar){
		if(fgetws(buf,size,_Fp) != NULL){
			if(!useReturnChar) buf[wcslen(buf)-1] = L'\0';
			return true;
		}
		return false;
	}


// AFileWriter //

	bool AFileWriter::putStr(cstr buf,bool useReturnChar){
		if(fputs(buf,_Fp) != EOF){
			if(useReturnChar) fputc('\n',_Fp);
			return true;
		}
		return false;
	}
	bool AFileWriter::putWStr(cwstr buf,bool useReturnChar){
		if(fputws(buf,_Fp) != EOF){
			if(useReturnChar) fputwc(L'\n',_Fp);
			return true;
		}
		return false;
	}

// FileReader //

	bool FileReader::open(cstr fname,bool binary,SHAREFRAG shflag){
		char mode[4];
		gen_fmode(binary?5:1,mode);
		FILE* fp = _fsopen(fname,mode,shflag);
		if(!fp) return false;
		_IsBinary = binary;
		if(_Fp) fclose(_Fp);
		_Fp = fp;
		return true;
	}
	bool FileReader::open(cwstr fname,bool binary,SHAREFRAG shflag){
		wchar_t mode[4];
		gen_fmode(binary?5:1,mode);
		FILE* fp = _wfsopen(fname,mode,shflag);
		if(!fp) return false;
		_IsBinary = binary;
		if(_Fp) fclose(_Fp);
		_Fp = fp;
		return true;
	}

// FileWriter //

	bool FileWriter::open(cstr fname,bool binary,bool add,SHAREFRAG shflag){
		char mode[4];
		gen_fmode((add?3:2)|(binary?4:0),mode);
		FILE* fp = _fsopen(fname,mode,shflag);
		if(!fp) return false;
		_IsBinary = binary;
		if(_Fp) fclose(_Fp);
		_Fp = fp;
		return true;
	}
	bool FileWriter::open(cwstr fname,bool binary,bool add,SHAREFRAG shflag){
		wchar_t mode[4];
		gen_fmode((add?3:2)|(binary?4:0),mode);
		FILE* fp = _wfsopen(fname,mode,shflag);
		if(!fp) return false;
		_IsBinary = binary;
		if(_Fp) fclose(_Fp);
		_Fp = fp;
		return true;
	}

// FileBoth //

	bool FileBoth::open(cstr fname,bool exist,bool binary,bool add,SHAREFRAG shflag){
		char mode[4];
		AFileReader::gen_fmode(4|(add?3:(exist?1:2))|(binary?4:0),mode);
		FILE* fp = _fsopen(fname,mode,shflag);
		if(!fp) return false;
		AFileReader::_IsBinary = binary;
		if(AFileReader::_Fp) fclose(AFileReader::_Fp);
		AFileReader::_Fp = fp;
		return true;
	}
	bool FileBoth::open(cwstr fname,bool exist,bool binary,bool add,SHAREFRAG shflag){
		wchar_t mode[4];
		AFileReader::gen_fmode(4|(add?3:(exist?1:2))|(binary?4:0),mode);
		FILE* fp = _wfsopen(fname,mode,shflag);
		if(!fp) return false;
		AFileReader::_IsBinary = binary;
		if(AFileReader::_Fp) fclose(AFileReader::_Fp);
		AFileReader::_Fp = fp;
		return true;
	}

} // namespace scpl
