// 
// WString.cpp
// 
// Copyright(C) 2006-2007 Ó
#include "stdafx.h"
#include "../scpl/WString.h"
#include <string.h>
#include <stdlib.h>
#include <ctype.h>





namespace scpl{

	inline ulong _cap(ulong x){return (x==0)?0:x-1;}
#define _CAP _cap(capacity())

	WString& WString::_insertChar(wchar_t c,ulong index){
		if(_CAP == _UseCount) _Text.aResize(_UseCount + 2,true);
		wstr pos = _Text.get() + index;
		if(index != _UseCount) memmove(pos + 1,pos,(_UseCount - index) * sizeof(wchar_t));
		*pos = c;
		++_UseCount;
		*(_Text.get()+_UseCount) = 0;
		return *this;
	}
	WString& WString::_insertStr(cwstr text,long count,ulong index){
		if(text && (count != 0)){
			if(count < 0) count = static_cast<long>(wcslen(text));
			long cp = _UseCount+count+1;
			if(static_cast<ulong>(cp) > _CAP) _Text.aResize(cp,true);
			wstr pos = _Text.get() + index;
			if(index != _UseCount){
				memmove(pos + count,pos,(_UseCount - index) * sizeof(wchar_t));
			}
			memcpy(pos,text,count * sizeof(wchar_t));
			_UseCount += count;
			*(_Text.get()+_UseCount) = 0;
		}
		return *this;
	}

	WString& WString::_insertNum(long l,ulong index,long radix){
		wchar_t buf[32];
		memset(buf,0,32 * sizeof(wchar_t));
		_ltow(l,buf,radix);
		return _insertStr(buf,-1,index);
	}
	WString& WString::_insertUNum(ulong l,ulong index,long radix){
		wchar_t buf[32];
		memset(buf,0,32 * sizeof(wchar_t));
		_ultow(l,buf,radix);
		return _insertStr(buf,-1,index);
	}
	void WString::removeAt(ulong index){
		wstr pos = _Text.get() + index;
		if(index != --_UseCount){
			memmove(pos,pos + 1,(_UseCount - index) * sizeof(wchar_t));
		}
		*(_Text.get() + _UseCount) = 0;
	}
	void WString::erage(ulong indexL,ulong indexR){
		if(indexR != _UseCount){
			memmove(_Text.get() + indexL,_Text + indexR,(_UseCount - indexR) * sizeof(wchar_t));
		}
		memset(_Text.get() + (_UseCount - indexR + indexL),0,(indexR - indexL) * sizeof(wchar_t));
		_UseCount -= (indexR - indexL);
	}
	void WString::clear(bool noClearCapacity){
		_UseCount = 0;
		if(!noClearCapacity) _Text.clear();
		else if(_Text) *_Text.get() = 0;
	}
	void WString::copy(cwstr s,long count){
		if(s && (count != 0)){
			if(count < 0) count = static_cast<long>(wcslen(s));
			if(static_cast<ulong>(count+1) > _CAP){
				_Text.aResize(count+1,true);
			}
			else *(_Text.get()+count) = 0;
			memcpy(_Text.get(),s,count*sizeof(wchar_t));
			_UseCount = count;
		}
		else clear(false);
	}
	bool WString::equals(cwstr s)const{return (wcscmp(_Text?_Text.begin():L"",s?s:L"") == 0);}
	long WString::find(wchar_t c,ulong start)const{
		cwstr a = wcschr(_Text+start,c);
		return a? static_cast<long>(a - _Text.get()) : -1;
	}
	long WString::find(cwstr c,ulong start)const{
		cwstr a = wcsstr(_Text+start,c);
		return a? static_cast<long>(a - _Text.get()) : -1;
	}
	void WString::toLower(){
		for(long i=_UseCount - 1;0<=i;--i){
			*(_Text.get() + i) = static_cast<wchar_t>(tolower(*(_Text + i)));
		}
	}
	void WString::toUpper(){
		for(long i=_UseCount - 1;0<=i;--i){
			*(_Text.get() + i) = static_cast<wchar_t>(toupper(*(_Text + i)));
		}
	}

	WString WString::strcat(cwstr a,cwstr b){
		size_t as = wcslen(a),bs = wcslen(b);
		WString string(static_cast<ulong>(as+bs+1));
		string = a;
		string += b;
		return WString(string._Text,string._UseCount);
	}
}
