// 
// sut.cpp
// 
// Copylight(C) 2007 Ó

#include "stdafx.h"
#include "../scpl/sut.h"
#include "../scpl/List.h"
#include "../scpl/exception.h"
#include <stdlib.h>

namespace scpl{
	namespace sut{

		static ulong	_all_count		= 0;
		static ulong	_all_fail_count	= 0;

		void _assert(int stop);

		inline cstr _getFileName(cstr fname){
			cstr p = fname + strlen(fname)-1;
			while(p != fname){
				if((*p == '/')||(*p == '\\')) return p+1;
				--p;
			}
			return p;
		}

		struct SUT_SECTION{
			ulong		_count;
			ulong		_fail_count;
			cstr		_name;
			cstr		_fname;
			int			_line;
			TestFunc	_func;
			int			_type;

			SUT_SECTION(cstr fname,int line,cstr name,TestFunc func,int type)
				:_line(line),_name(name),_count(0),_fail_count(0),_func(func),_type(type)
			{
				_fname = _getFileName(fname);
			}

			void call(){_func();}

			void test(){++_all_count;++_count;}
			void fail(){++_all_fail_count;++_fail_count;}

			void result(size_t x){
				double complate;
				if(_count == 0) complate = 0.0;
				else complate = (1.0 - _fail_count/static_cast<double>(_count))*100.0;
				printf("%*s:[tests:%4i,fails:%4i,succeeds:%4i,complate:%3.2f%%]\n",
					x,
					_name,
					_count,
					_fail_count,
					_count - _fail_count,
					complate
				);
			}
			bool equals(const SUT_SECTION& s)const{
				return (_func == s._func)&&(_type == s._type);
			}
			bool operator==(const SUT_SECTION& s)const{return equals(s);}
			bool operator!=(const SUT_SECTION& s)const{return !equals(s);}
		};

		class SUTSection{
		public:
			SUTSection():_SectionNameMaxLen(11),_Section(NULL),_InSection(false){}
			~SUTSection(){}

			void add(cstr fname,int line,cstr name,TestFunc func,int type){
				_List.lastIn(SUT_SECTION(fname,line,name,func,type));
				size_t s = strlen(name);
				if(_SectionNameMaxLen < s) _SectionNameMaxLen = s;
			}

			bool operator()(){
				SUT_SECTION *it=_List.begin(),*end=_List.end();
				for(;it<end;++it){
					_Section = it;
					_InSection = true;
					try{it->call();}
					catch(sut_assert){}
					catch(...){throw;}
					_InSection = false;
					if((_Section->_fail_count != 0)&&(_Section->_type != 0)){
						_assert(_Section->_type);
					}
				}
				return (_all_fail_count == 0);
			}

			bool inSection()const{return _InSection;}

			void test(){
				if(_Section) _Section->test();
				else ++_all_count;
			}
			void fail(){
				if(_Section) _Section->fail();
				else ++_all_fail_count;
			}

			void result(){
				double complate;
				if(_all_count == 0) complate = 0.0;
				else complate = (1.0 - _all_fail_count/static_cast<double>(_all_count))*100.0;
				if(_List.empty()){
					printf("result:[tests:%4i,fails:%4i,succeeds:%4i,complate:%3.2f%%]\n",
						_all_count,
						_all_fail_count,
						_all_count - _all_fail_count,
						complate
					);
				}
				else{
					SUT_SECTION *it=_List.begin(),*end=_List.end();
					for(;it<end;++it) it->result(_SectionNameMaxLen);
					for(size_t i=0;i<_SectionNameMaxLen;++i) putchar('-');
					printf("-------------------------------------------------------\n");
					printf("%*s:[tests:%4i,fails:%4i,succeeds:%4i,complate:%3.2f%%]\n",
						_SectionNameMaxLen,
						"all results",
						_all_count,
						_all_fail_count,
						_all_count - _all_fail_count,
						complate
					);
				}
			}

		private:
			DList<SUT_SECTION>	_List;
			size_t				_SectionNameMaxLen;
			SUT_SECTION*		_Section;
			bool				_InSection;

		};

		SUTSection _section;
	

		inline bool check_fail(bool b,cstr fname,int line){
			_section.test();
			if(!b){
				_section.fail();
				printf("test fail [file:%s,line:%5i]:",_getFileName(fname),line);
			}
			return b;
		}
		void _assert(int stop){
			if(stop != 0){
				if(_section.inSection()) throw sut_assert();
				printf("The test which must be successful went wrong.\nTherefore, a test is stopped here.\n");
				_test_result();
				if(stop != 1){
					printf("It will end, if an enter key is pushed.");
					getchar();
				}
				exit(-1);
			}
		}


		bool _test_start(){return _section();}
		void _test_result(){_section.result();}

		void _test_addfunc(int type,cstr fname,int line,cstr funcname,TestFunc func){
			_section.add(fname,line,funcname,func,type);
		}

		void _test_bool(int type,bool b,cstr fname,int line,cstr sx){
			if(!check_fail(b,fname,line)){
				printf("\"%s\" is false.\n",sx);
				_assert(type);
			}
		}
		void _test_Int(int type,bool b,cstr fname,int line,cstr v,cstr sx,cstr sy,int x,int y){
			if(!check_fail(b,fname,line)){
				printf("{[\"%s\"=%i]%s[\"%s\"=%i]} -> false.\n",sx,x,v,sy,y);
				_assert(type);
			}
		}
		void _test_Hex(int type,bool b,cstr fname,int line,cstr v,cstr sx,cstr sy,int x,int y){
			if(!check_fail(b,fname,line)){
				printf("{[\"%s\"=%x]%s[\"%s\"=%x]} -> false.\n",sx,x,v,sy,y);
				_assert(type);
			}
		}
		void _test_I64(int type,bool b,cstr fname,int line,cstr v,cstr sx,cstr sy,i64 x,i64 y){
			if(!check_fail(b,fname,line)){
#if defined(_MSC_VER)&&(_MSC_VER>=1400)
				printf("{[\"%s\"=%I64i]%s[\"%s\"=%I64i]} -> false.\n",sx,x,v,sy,y);
#else
				printf("{[\"%s\"=%i]%s[\"%s\"=%i]} -> false.\n",sx,(long)x,v,sy,(long)y);
#endif
				_assert(type);
			}
		}
		void _test_H64(int type,bool b,cstr fname,int line,cstr v,cstr sx,cstr sy,i64 x,i64 y){
			if(!check_fail(b,fname,line)){
#if defined(_MSC_VER)&&(_MSC_VER>=1400)
				printf("{[\"%s\"=%I64x]%s[\"%s\"=%I64x]} -> false.\n",sx,x,v,sy,y);
#else
				printf("{[\"%s\"=%x]%s[\"%s\"=%x]} -> false.\n",sx,(ulong)x,v,sy,(ulong)y);
#endif
				_assert(type);
			}
		}
		void _test_Dbl(int type,bool b,cstr fname,int line,cstr v,cstr sx,cstr sy,double x,double y){
			if(!check_fail(b,fname,line)){
				printf("{[\"%s\"=%g]%s[\"%s\"=%g]} -> false.\n",sx,x,v,sy,y);
				_assert(type);
			}
		}
		void _test_Ptr(int type,bool b,cstr fname,int line,cstr v,cstr sx,cstr sy,const void* x,const void* y){
			if(!check_fail(b,fname,line)){
				printf("{[\"%s\"=%p]%s[\"%s\"=%p]} -> false.\n",sx,x,v,sy,y);
				_assert(type);
			}
		}

	}
} // namespace scpl