#include "stdafx.h"
#include "test_funcs.h"
#include <scpl/algorithm.h>

using namespace scpl;

static long ary1[10]={61,32556,1235,62,46,22,257,234,72,2};
static short ary2[10]={94,94,276,12345,123,4,34,51,123,123};
static char ary3[10]={0,1,0,1,0,1,0,1,0,1};

template <class A> struct ExIf : public FuncIf<A,A>{
	virtual bool operator()(const A& a,const A& b)const{return (a > 100)&&(a == b);}
};

void test_algorithm(){
	SUT_ASSERT(!alg::isOverlap(ary1,10));
	SUT_ASSERT(!alg::isOverlap(ary1));
	SUT_ASSERT( alg::isOverlap(ary2,10));
	SUT_ASSERT( alg::isOverlap(ary2));
	SUT_ASSERT( alg::isOverlap(ary3,10));
	SUT_ASSERT( alg::isOverlap(ary3));

	SUT_ASSERT(!alg::isOverlapF(ary1,10	,ExIf<long>()));
	SUT_ASSERT(!alg::isOverlapF(ary1	,ExIf<long>()));
	SUT_ASSERT( alg::isOverlapF(ary2,10	,ExIf<short>()));
	SUT_ASSERT( alg::isOverlapF(ary2	,ExIf<short>()));
	SUT_ASSERT(!alg::isOverlapF(ary3,10	,ExIf<char>()));
	SUT_ASSERT(!alg::isOverlapF(ary3	,ExIf<char>()));

	const long	*l1 = NULL,*l2 = NULL;
	const short	*s1 = NULL,*s2 = NULL;
	const char	*c1 = NULL,*c2 = NULL;

	SUT_ASSERT_EQUALS(Int,alg::isOverlapEx(ary1,10	,&l1,&l2),1);
	SUT_ASSERT_EQUALS(Ptr,l1,NULL);
	SUT_ASSERT_EQUALS(Ptr,l2,NULL);
	SUT_ASSERT_EQUALS(Int,alg::isOverlapEx(ary1		,&l1,&l2),1);
	SUT_ASSERT_EQUALS(Ptr,l1,NULL);
	SUT_ASSERT_EQUALS(Ptr,l2,NULL);
	SUT_ASSERT_EQUALS(Int,alg::isOverlapEx(ary2,10	,&s1,&s2),0);
	SUT_ASSERT_EQUALS(Ptr,s1,ary2);
	SUT_ASSERT_EQUALS(Ptr,s2,ary2+1);
	SUT_ASSERT_EQUALS(Int,alg::isOverlapEx(ary2		,&s1,&s2),0);
	SUT_ASSERT_EQUALS(Ptr,s1,ary2);
	SUT_ASSERT_EQUALS(Ptr,s2,ary2+1);
	SUT_ASSERT_EQUALS(Int,alg::isOverlapEx(ary3,10	,&c1,&c2),0);
	SUT_ASSERT_EQUALS(Ptr,c1,ary3);
	SUT_ASSERT_EQUALS(Ptr,c2,ary3+2);
	SUT_ASSERT_EQUALS(Int,alg::isOverlapEx(ary3		,&c1,&c2),0);
	SUT_ASSERT_EQUALS(Ptr,c1,ary3);
	SUT_ASSERT_EQUALS(Ptr,c2,ary3+2);

	SUT_ASSERT_EQUALS(Int,alg::isOverlapExF(ary1,10	,ExIf<long>(),&l1,&l2),1);
	SUT_ASSERT_EQUALS(Ptr,l1,NULL);
	SUT_ASSERT_EQUALS(Ptr,l2,NULL);
	SUT_ASSERT_EQUALS(Int,alg::isOverlapExF(ary1	,ExIf<long>(),&l1,&l2),1);
	SUT_ASSERT_EQUALS(Ptr,l1,NULL);
	SUT_ASSERT_EQUALS(Ptr,l2,NULL);
	SUT_ASSERT_EQUALS(Int,alg::isOverlapExF(ary2,10	,ExIf<short>(),&s1,&s2),0);
	SUT_ASSERT_EQUALS(Ptr,s1,ary2+4);
	SUT_ASSERT_EQUALS(Ptr,s2,ary2+8);
	SUT_ASSERT_EQUALS(Int,alg::isOverlapExF(ary2	,ExIf<short>(),&s1,&s2),0);
	SUT_ASSERT_EQUALS(Ptr,s1,ary2+4);
	SUT_ASSERT_EQUALS(Ptr,s2,ary2+8);
	SUT_ASSERT_EQUALS(Int,alg::isOverlapExF(ary3,10	,ExIf<char>(),&c1,&c2),1);
	SUT_ASSERT_EQUALS(Ptr,c1,NULL);
	SUT_ASSERT_EQUALS(Ptr,c2,NULL);
	SUT_ASSERT_EQUALS(Int,alg::isOverlapExF(ary3	,ExIf<char>(),&c1,&c2),1);
	SUT_ASSERT_EQUALS(Ptr,c1,NULL);
	SUT_ASSERT_EQUALS(Ptr,c2,NULL);

}