#include "stdafx.h"
#include "test_funcs.h"
#include <scpl/smart_ptr.h>
#include "CountStruct.h"

using namespace scpl;

typedef smart_ptr<CountStruct> CSAP;

void tsp_1(){
	CSAP a(new CountStruct());
	CSAP b(new CountStruct());
	CSAP c(new CountStruct());
	CSAP d;

	SUT_ASSERT(!a.empty());
	SUT_ASSERT(!b.empty());
	SUT_ASSERT(!c.empty());
	SUT_ASSERT( d.empty());
	SUT_ASSERT_EQUALS(Int,a.count(),1);
	SUT_ASSERT_EQUALS(Int,b.count(),1);
	SUT_ASSERT_EQUALS(Int,c.count(),1);
	SUT_ASSERT_EQUALS(Int,d.count(),0);
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),3);
	d = a;
	SUT_ASSERT(!d.empty());
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),3);
	d = a;
	SUT_ASSERT(!d.empty());
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),3);
	b = c;
	SUT_ASSERT(!b.empty());
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),2);
	SUT_ASSERT(d == a);
	SUT_ASSERT(b == c);
	SUT_ASSERT(a != c);
	d = NULL;
	SUT_ASSERT(d.empty());
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),2);
	SUT_ASSERT(d != a);
	b = NULL;
	SUT_ASSERT(b.empty());
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),2);
	SUT_ASSERT(b != c);
	SUT_ASSERT(b == d);
}

void tsp_2(){
	CSAP a(new CountStruct());
	CSAP b(a);
	CSAP c(new CountStruct());
	CSAP d(c);
	SUT_ASSERT_EQUALS(Int,a.count(),2);
	SUT_ASSERT_EQUALS(Int,c.count(),2);
	d = a;
	SUT_ASSERT_EQUALS(Int,a.count(),3);
	SUT_ASSERT_EQUALS(Int,c.count(),1);
	d.swap(c);
	SUT_ASSERT_EQUALS(Int,a.count(),3);
	SUT_ASSERT_EQUALS(Int,b.count(),3);
	SUT_ASSERT_EQUALS(Int,c.count(),3);
	SUT_ASSERT_EQUALS(Int,d.count(),1);
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),2);
	d = a;
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),1);
	SUT_ASSERT_EQUALS(Int,c.count(),4);
	a = b = new CountStruct();
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),2);
	SUT_ASSERT_EQUALS(Int,c.count(),2);
	SUT_ASSERT_EQUALS(Int,a.count(),2);
	a.clear();
	SUT_ASSERT_EQUALS(Int,a.count(),0);
	SUT_ASSERT_EQUALS(Int,b.count(),1);
	CountStruct* cs = new CountStruct();
	b = cs;
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),2);
	SUT_ASSERT_EQUALS(Int,b.count(),1);
	const CSAP* s = &a;
	SUT_ASSERT_EQUALS(Int,s->count(),0);
	SUT_ASSERT(s->empty());
	SUT_ASSERT_EQUALS(Ptr,s->get(),NULL);
	s = &b;
	SUT_ASSERT_EQUALS(Int,s->count(),1);
	SUT_ASSERT(!s->empty());
	SUT_ASSERT_EQUALS(Ptr,s->get(),cs);
	SUT_ASSERT_EQUALS(Int,(*s).getIndirect().i,cs->i);
	SUT_ASSERT_EQUALS(Int,(*(*s)).i,cs->i);
}

void test_smart_ptr(){
	tsp_1();
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),0);
	tsp_2();
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),0);
}