
import sdl4gcj.Sys;
import sdl4gcj.SDLConstants;
import sdl4gcj.video.*;
import sdl4gcj.event.*;
import sdl4gcj.input.Keyboard;
import sdl4gcj.mixer.*;

public class MixerTest implements  SDLConstants, MixerConstants
{
	static final String DEFAULT_MUSIC_FILE = "sounds/music.wav";

	public static void main(String[] args)
	{
		String musicFile = DEFAULT_MUSIC_FILE;
		if (args.length >= 1) musicFile = args[0];
		
		if (Sys.init(0) != 0) System.exit(0);

		System.out.println(" Compiled SDL_mixer Version : " + Mixer.compiledVersion());
		System.out.println("   Linked SDL_mixer Version : " + Mixer.linkedVersion());

		try
		{
			Mixer mixer = Mixer.openAudio(MIX_DEFAULT_FREQUENCY,
				MIX_DEFAULT_FORMAT, MIX_DEFAULT_CHANNELS, 4096);
//			Mixer mixer = Mixer.openAudio(44100, AUDIO_S16, 2, 4096);
//			Mixer mixer = Mixer.openAudio(22050, AUDIO_S16, 2, 4096);

			Music music = new Music(musicFile);

			mixer.playMusic(music);

			while (mixer.playingMusic())
			{
				Sys.delay(10);
			}

			System.out.println("Free music data!");
			music.freeMusic();
			System.out.println("Close audio device!");
			mixer.closeAudio();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			System.out.println("Quit SDL system!");
			Sys.quit();
		}

		return ;
	}
}

