/************************************************************
Copyright 2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/
package sdl4gcj.ttf;

import sdl4gcj.video.Color;
import sdl4gcj.video.Surface;

public class Font implements FontConstants
{
	// instance variables
	protected gnu.gcj.RawData implementation = null;

	// class methods 

	/**
	* Open font.
	* @param fontFilePath A path to TTF font file
	* @param ptSize Point size.
	* @return The loaded font object.
	**/
	public static native Font openFont(String fontFilePath, int ptSize);

	/**
	* Open font with face index.
	* @param fontFilePath A path to TTF font file
	* @param ptSize Point size.
	* @param index choose a font face from a multiple font face containing file.
	*              The first face is always index 0.
	* @return The loaded font object.
	**/
	public static native Font openFontIndex(String fontFilePath,
		int ptSize, long index);


	// constractors 
	private Font()
	{
	}

	// instance methods 
	
	/**
	* Get font render style.
	* The style as a bitmask composed of the following masks:
	* <ul>
	* <li><code>TTF_STYLE_BOLD</code></li>
	* <li><code>TTF_STYLE_ITALIC</code></li>
	* <li><code>TTF_STYLE_UNDERLINE</code></li>
	* </ul>
	* If no style is set then <code>TTF_STYLE_NORMAL</code> is returned.
	* @return Font Style
	* @see TTF_STYLE_BOLD
	* @see TTF_STYLE_ITALIC
	* @see TTF_STYLE_UNDERLINE
	* @see TTF_STYLE_NORMAL
	**/
	public native int getFontStyle();

	/**
	* Set font render style.
	* The style as a bitmask composed of the following masks:
	* <ul>
	* <li><code>TTF_STYLE_BOLD</code></li>
	* <li><code>TTF_STYLE_ITALIC</code></li>
	* <li><code>TTF_STYLE_UNDERLINE</code></li>
	* </ul>
	* If you want no style, set <code>TTF_STYLE_NORMAL</code>.
	* @param fontStyle The font render style 
	* @see TTF_STYLE_BOLD
	* @see TTF_STYLE_ITALIC
	* @see TTF_STYLE_UNDERLINE
	* @see TTF_STYLE_NORMAL
	**/
	public native void setFontStyle(int fontStyle);

	/**
	* Get font maximum total height.
	* @return The maximum pixel height of all glyphs in the font.
	**/
	public native int fontHeight();

	/**
	* Get font highest ascent (height above base)
	* @return The maximum pixel ascent of all glyphs in the font.
	**/
	public native int fontAscent();

	/**
	* Get font lowest descent (height below base)
	* @return The maximum pixel height of all glyphs in the font.
	**/
	public native int fontDescent();

	/**
	* Get font recommended line spacing.
	* @return The reccomended pixel height of a rendered line of text.
	**/
	public native int fontLineSkip();

	/**
	* Get the number of faces in a font.
	* @return The number of font faces in this font.
	**/
	public native int fontFaces();

	/**
	* Check font has fixed width.
	* @return <code>true</code> if receiver is a fixed width font.
	*         <code>false</code> otherwise.
	**/
	public native boolean fontFaceIsFixedWidth();

	/**
	* Get font face family name.
	* @return font face family name.
	**/
	public native String fontFaceFamilyName();

	/**
	* Get font face style name.
	* @return font face style name.
	**/
	public native String fontFaceStyleName();

	/**
	* Get width of rendered string
	* @param text The char sequence to calculate width
	* @return  width of rendered string
	**/
	public native int widthText(CharSequence text);

	/**
	* Get height of rendered string
	* @param text The char sequence to calculate height
	* @return  height of rendered string
	**/
	public native int heightText(CharSequence text);

	/**
	* renderTextSolid
	* @param text Char sequence to render
	* @param foregroundColor The color to redner the text
	* @return  Rendered Surface
	**/
	public native Surface renderTextSolid(CharSequence text,
		Color foregroundColor);

	/**
	* renderTextShaded
	* @param text Char sequence to render
	* @param foregroundColor The color to redner the text
	* @param backgroundColor The color to redner the background box
	* @return  Rendered Surface
	**/
	public native Surface renderTextShaded(CharSequence text,
		Color foregroundColor, Color backgroundColor);

	/**
	* renderTextBlended
	* @param text Char sequence to render
	* @param foregroundColor The color to redner the text
	* @return  Rendered Surface
	**/
	public native Surface renderTextBlended(CharSequence text,
		Color foregroundColor);

	/**
	* Close font.
	**/
	public native void closeFont();

	public void finalize()
	{
		this.closeFont();
	}
}
