package sdl4gcj.video;
import sdl4gcj.SDLConstants;

public class Cursor
{
	// class method 
	/**
	* Set the currently active mouse cursor.
	* SDL_SetCursor(SDL_Cursor* cursor) wrapper.
	**/
	static native void setCursor(Cursor cursor);

	/**
	* Get the currently active mouse cursor.
	* SDL_Cursor* SDL_GetCursor() wrapper.
	**/
	static native Cursor getCursor();

	/**
	* Toggle whether or not the cursor is shown on the screen.
	* Passing <code>true</code> displays the cursor and passing
	* <code>false</code> hides it. 
	* SDL_ShowCursor(int toggle) wrapper.
	* @return new cursor visibility.
	**/
	static native boolean showCursor(boolean visibility);

	/**
	* Toggle whether or not the cursor is shown on the screen.
	* Passing <code>true</code> displays the cursor and passing
	* <code>false</code> hides it. 
	* SDL_ShowCursor(int toggle) wrapper.
	**/
	static native void setVisible(boolean visibility);

	/**
	* Returns <code>true</code> if the cursor is visible.
	* SDL_ShowCursor(int toggle) wrapper.
	* @return current cursor visible.
	**/
	static native boolean isVisible();


	// constructor
	protected Cursor()
	{
	}

	public Cursor(byte[] data, byte[] mask, 
		int w, int h, int hotX, int hotY)
	{
		this.initCursor(data, mask, w, h, hotX, hotY);
	}

	// instance method
	public native void freeCursor();

	protected void finalize() throws Throwable
	{
		this.freeCursor();
		super.finalize();
	}

	private native void initCursor(byte[] data, byte[]mask, int w, int h, int hotX, int hotY);

	gnu.gcj.RawData implementation = null;

}
