package sdl4gcj.video;

public class Palette
{
	public static int DEFAULT_SIZE = 0xff;

	/**
	* SDL_Color colors[size]
	**/
	protected gnu.gcj.RawData colors = null;

	/**
	* size of palette table
	**/
	private int size;

	public Palette()
	{
		this(DEFAULT_SIZE);
	}

	public Palette(int size)
	{
		this.initPalette(size);
	}

	public Palette(Color[] colors)
	{
		this(colors.length);
		this.setColors(colors);
	}

	/**
	* gets size of this palette.
	**/
	public int getSize() { return size; }

	/**
	* gets color at <code>index</code>.
	**/
	public native Color getColorAt(int index);

	/**
	* sets color at <code>index</code> with <code>color</code>.
	**/
	public void setColorAt(int index, Color color)
	{
		this.setColorAt(index, color.r, color.g, color.b);
	}

	/**
	* sets color at <code>index</code> with RGB value.
	**/
	public native void setColorAt(int index, int r, int g, int b);

	/**
	* sets colors as array.
	**/
	public Color[] getColors()
	{
		Color[] colors = new Color[this.getSize()];
		for (int i = this.getSize()-1;i >= 0;i--)
			colors[i] = getColorAt(i);
		return colors;
	}

	/**
	* sets palette with <code>colors</code>.
	**/
	public void setColors(Color[] colors)
	{
		int count = this.getSize();
		if (colors.length < count) count = colors.length;

		for (int i = count-1;i >= 0;i--)
			setColorAt(i, colors[i]);
	}

	public String toString()
	{
		StringBuffer buffer = new StringBuffer(super.toString());
		int size = this.getSize();
		for (int i = 0;i < size;i++)
		{
			buffer.append("color[");
			buffer.append(i);
			buffer.append("] = ");
			buffer.append(this.getColorAt(i));
			buffer.append("\n");
		}
		return buffer.toString();
	}

	public void finalize() throws Throwable
	{
		this.freePalette();
		super.finalize();
	}

	protected native void initPalette(int size);
	protected native void freePalette();
}
