/************************************************************
Copyright (C) 2004-2005  Masahiko SAWAI 
************************************************************/
import sdl4gcj.*;
import sdl4gcj.video.*;
import sdl4gcj.event.*;
import sdl4gcj.input.*;
import gl4gcj.GL;

public class TestGL extends GL implements SDLConstants
{
	static int x_angle = 0;
	static int y_angle = 0;

	public static void display()
	{
		glClear(GL_COLOR_BUFFER_BIT);

		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		glRotated(x_angle, 1.0, 0.0, 0.0);
		glRotated(y_angle, 0.0, 1.0, 0.0);

		glBegin(GL_POLYGON);
		glColor3d(1.0, 0.0, 1.0);
		glVertex2d(-0.7,  0.7);
		glColor3d(1.0, 0.0, 0.0);
		glVertex2d(-0.7, -0.7);
		glColor3d(0.0, 1.0, 0.0);
		glVertex2d( 0.7, -0.7);
		glColor3d(0.0, 0.0, 1.0);
		glVertex2d( 0.7,  0.7);
		glEnd();
	}

	public static void main(String[] args)
	{
		if (SDLSystem.init(SDL_INIT_VIDEO) != 0)
		{
			System.out.println("Init() fail");
			System.exit(0);
		}

		SDLOptionParser optParser = new SDLOptionParser(
			640, 480, 16, SDL_OPENGL);
		optParser.parse(args);

		try
		{
			Screen.glSetAttribute(SDL_GL_RED_SIZE, 5);
			Screen.glSetAttribute(SDL_GL_GREEN_SIZE, 5);
			Screen.glSetAttribute(SDL_GL_BLUE_SIZE, 5);
			Screen.glSetAttribute(SDL_GL_DEPTH_SIZE, 16);
			Screen.glSetAttribute(SDL_GL_DOUBLEBUFFER, 1);

			Screen screen = Screen.setVideoMode(
				optParser.getScreenWidth(),
				optParser.getScreenHeight(),
				16, optParser.getVideoFlags());

			int frames = 0;
			boolean done = false;
			EventManager event = new EventManager();
			long totalTicks = SDLSystem.getTicks();
			while (!done)
			{
				while (event.pollEvent() > 0)
				{
					switch (event.type)
					{
						case SDLEvent.SDL_KEYDOWN :
							if ((event.keydown.sym == SDLK_ESCAPE) ||
								(event.keydown.sym == SDLK_q))
								done = true;
							break;
						case SDLEvent.SDL_QUIT:
							done = true;
							break;
						default:
							break;
					}
				}

				frames++;
				x_angle = (x_angle + 2) % 360;
				y_angle = (y_angle + 1) % 360;
				display();
				screen.glSwapBuffers();
				SDLSystem.delay(20);
			}

			totalTicks = SDLSystem.getTicks() - totalTicks;
			System.out.println(((double)frames * 1000) / totalTicks + " (Frame per Second)");
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			SDLSystem.quit();
		}
	}
}
