/************************************************************
Copyright (C) 2004-2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/
package sdl4gcj;

/** \mainpage
* This is a sdl4gcj API document.
* <p>
* sdl4gcj is a GCJ(http://gcc.gnu.org/java/) binding to 
* SDL(Simple DirectMedia Layer : http://www.libsdl.org/).
* </p>
**/

/** \package sdl4gcj
* SDL System initialization and finalization.
**/
/** \package sdl4gcj.input 
* Input System. Keyboard, mouse and joystick.
**/
/** \package  sdl4gcj.event
* Event System.
**/
/** \package  sdl4gcj.video
* Video System. Drawing 2d graphics system.
**/
/** \package  sdl4gcj.cdrom
* Audio CD System. 
**/

/**
* A collection of Utilities for SDL System.
* SDLSystem class has wrapper for following functions and constants.
* <ul>
* <li> SDL_Init() </li>
* <li> SDL_Quit() </li>
* <li> SDL_InitSubSystem() </li>
* <li> SDL_QuitSubSystem() </li>
* <li> SDL_Linked_Version() </li>
* <li> SDL_Delay() </li>
* <li> SDL_GetTicks() </li>
* <li> SDL_COMPILEDVERSION </li>
* <li> SDL_BYTEORDER </li>
* </ul>
* @author Masahiko SAWAI
**/
public final class SDLSystem implements SDLSystemConstants
{
	// system

	/**
	* Initialize SDL system.
	* This should be called before all other SDL functions.
	* The flags parameter specifies what part(s) of SDL to initialize.
	* This method is a wrapper for SDL_Init() function.
	* <ul>
	* <li>SDL_INIT_TIMER</li>
	* <li>SDL_INIT_AUDIO</li>
	* <li>SDL_INIT_VIDEO</li>
	* <li>SDL_INIT_CDROM</li>
	* <li>SDL_INIT_JOYSTICK</li>
	* <li>SDL_INIT_NOPARACHUTE</li>
	* <li>SDL_INIT_EVENTTHREAD</li>
	* <li>SDL_INIT_EVERYTHING</li>
	* </ul>
	**/
	public static native final void init(int flags);

	/**
	* Initialize subsystem.
	* This method is a wrapper for SDL_InitSubSystem() function.
	**/
	public static native final void initSubSystem(int flags);

	/**
	* Check which subsystems are initialized.
	* This method is a wrapper for SDL_WasInit() function.
	* @return wasInit returns a bitwised  OR'd combination of the
	*         initialized subsystems.
	**/
	public static native final int wasInit(int flags);

	/**
	* Finalize subsystem.
	* This method is a wrapper for SDL_QuitSubSystem() function.
	**/
	public static native final void quitSubSystem(int flags);

	/**
	* Finalize SDL system.
	* This method is a wrapper for SDL_Quit() function.
	**/
	public static native final void quit();

	/**
	* Get version of compiled library.
	* @return version of compile library 
	**/
	public static native Version compiledVersion();

	/**
	* Get the version of linked library. ( SDL_Linked_Version() )
	* @return version of linked library
	**/
	public static native Version linkedVersion();

	/**
	* Wait a specified number of miliseconds.
	* SDL_Delay()
	* @param ms delay time (milisecond)
	**/
	public static native final void delay(long ms);

	/**
	* Get a number of miliseconds since the SDL system initialization.
	* SDL_GetTicks()
	**/
	public static native final long getTicks();

	/**
	* Get a native byte order.
	* SDL_BYTEORDER
	* @return byte order SDL_LIL_ENDIAN or SDL_BIG_ENDIAN 
	* @see SDL_LIL_ENDIAN
	* @see SDL_BIG_ENDIAN
	**/
	public static native final int byteOrder();

	private SDLSystem(){}
}
