/************************************************************
Copyright (C) 2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/
package sdl4gcj.mixer;

import sdl4gcj.SDLException;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;


public class Chunk implements MixerConstants
{
	// instance variables
	protected gnu.gcj.RawData implementation = null;

	// class methods
	public static native Chunk loadWAV(String filePath);
	public static Chunk loadWAV(File file)
	{
		return loadWAV(file.getAbsolutePath());
	}

	public static native Chunk loadWAV(byte[] bytes, int offset, int length);

	public static Chunk loadWAV(byte[] bytes)
	{
		return loadWAV(bytes, 0, bytes.length);
	}

	public static Chunk loadWAV(InputStream inputStream)
	{
		Chunk result = null;
		byte[] bytes = new byte[4096];
		int index = 0;
		int data = -1;
		
		try
		{
			while ((data = inputStream.read()) != -1)
			{
				if (index >= bytes.length)
					bytes = new byte[bytes.length*2];
				bytes[index++] = (byte)data;
			}
			result = loadWAV(bytes, 0, index);
		}
		catch (IOException ioe)
		{
			ioe.printStackTrace();
		}

		return result;
	}

	// constructors
	protected Chunk()
	{
	}

	// instance methods
	public native void freeChunk();

	protected void finalize() throws Throwable
	{
		this.freeChunk();
		super.finalize();
	}

	/**
	* Set volume.
	* @param volume new volume (0 - 128)
	* @return original volume (0 - 128)
	**/
	public native int setVolume(int volume);
}

