/************************************************************
Copyright (C) 2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/
#include "sdl4gcj/mixer/Music.h"

#include "sdl4gcj/SDLException.h"

#include <gcj/cni.h>
#include <stdlib.h>
#include <string.h>
#include <SDL_mixer.h>


using namespace sdl4gcj::mixer;

// function
static
inline
sdl4gcj::SDLException*
createFreedMusicException()
{
	return new sdl4gcj::SDLException(JvNewStringLatin1("This Music was already freed."));
}

// class methods
Music*
Music::loadMUS(::java::lang::String * filePath)
{
	JvInitClass(&Music::class$);
	Music* music = NULL;

	jbyteArray byteArray = filePath->getBytes();
	int length = JvGetArrayLength(byteArray);
	jbyte* bytes = elements(byteArray);
	char buffer[length+1];

	memcpy(buffer, bytes, length);
	buffer[length] = '\0';

	Mix_Music* nativeMusic = Mix_LoadMUS(buffer);
	if (nativeMusic == NULL) throw new SDLException();

	music = new Music();
	music->implementation = (::gnu::gcj::RawData*)nativeMusic;

	return music;
}

// instance methods
jint
Music::getMusicType()
{
	if (this->implementation == NULL) throw createFreedMusicException();
	Mix_Music* nativeMusic = (Mix_Music*)this->implementation;
	return ::Mix_GetMusicType(nativeMusic);
}


void
Music::freeMusic()
{
	if (this->implementation != NULL) 
	{
		::Mix_FreeMusic((Mix_Music *)this->implementation);
		this->implementation = NULL;
	}

	return ;
}

