/*
    SDL_archive
    Copyright (C) 2004  Kazunori Itoyanagi

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Kazunori Itoyanagi
    itkz@users.sourceforge.jp
*/

#include<stdio.h>
#include<stdlib.h>

#include"SDL_archive.h"
#include"SDL_version.h"


#define DEFAULT_ARCHIVERS_ALLOCATE 2


typedef struct _Archiver
{
	Archive_IsOpenable isOpenable;
	Archive_FromFormat fromFormat;
} Archiver;


struct _ArchiverList
{
	int archiversNum;
	int archiversAllocated;
	Archiver *archivers;
};


const SDL_version *Archive_Linked_Version(void)
{
	static SDL_version linked_version;
	ARCHIVE_VERSION(&linked_version);
	return(&linked_version);
}


SDL_Archive *Archive_Alloc(void)
{
	SDL_Archive *archive;
	
	archive = malloc(sizeof(SDL_Archive));
	if (archive == NULL) {
		return NULL;
	}
	archive->data = NULL;
	archive->open = NULL;
	archive->numopen = NULL;
	archive->name2index = NULL;
	archive->filenum = NULL;
	archive->finish = NULL;
	archive->get_char = NULL;
	archive->read = NULL;
	archive->seek = NULL;
	archive->size = NULL;
	archive->tell = NULL;
	archive->eof = NULL;
	archive->close = NULL;
	
	return archive;
}


void Archive_FreeMainContext(SDL_Archive *archive)
{
	free(archive);
}


ArchiverList *ArchiverList_Create(void)
{
	ArchiverList *archiverList;
	
	archiverList = (ArchiverList*)malloc(sizeof(ArchiverList));
	
	archiverList->archivers =
		(Archiver*)malloc(sizeof(Archiver) * DEFAULT_ARCHIVERS_ALLOCATE);
	archiverList->archiversAllocated = DEFAULT_ARCHIVERS_ALLOCATE;
	archiverList->archiversNum = 0;
	
	return archiverList;
}


int ArchiverList_AddArchiver(
	ArchiverList *archiverList,
	Archive_IsOpenable isOpenable,
	Archive_FromFormat fromFormat)
{
	Archiver *allocateTemp;
	
	if (archiverList->archiversNum >= archiverList->archiversAllocated) {
		allocateTemp = (Archiver*)realloc(
			archiverList->archivers,
			sizeof(Archiver) * archiverList->archiversAllocated * 2);
		if (allocateTemp == NULL) {
			return -1;
		}
		archiverList->archivers = allocateTemp;
		archiverList->archiversAllocated *= 2;
	}
	
	archiverList->archivers[archiverList->archiversNum].isOpenable =
		isOpenable;
	archiverList->archivers[archiverList->archiversNum].fromFormat =
		fromFormat;
	
	archiverList->archiversNum++;
	
	return 0;
}


SDL_Archive *Archive_FromArchiverList(
	ArchiverList *archiverList,
	const char *file)
{
	int i;
	SDL_Archive *archive;
	
	for (i = 0; i < archiverList->archiversNum; i++) {
		if (archiverList->archivers[i].isOpenable(file)) {
			archive = archiverList->archivers[i].fromFormat(file);
			if (archive != NULL) {
				return archive;
			}
		}
	}
	return NULL;
}


void ArchiverList_Free(ArchiverList *archiverList)
{
	if (archiverList != NULL) {
		free(archiverList->archivers);
		free(archiverList);
	}
}



