/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.crypto;

import java.security.MessageDigest;
import org.maachang.crypto.CryptoAse;
import org.maachang.crypto.CryptoRsaFailureException;
import org.maachang.crypto.CryptoRsaKey;
import org.maachang.crypto.CryptoRsaNotSigningException;
import org.maachang.crypto.CryptoUtils_Base64;
import org.maachang.crypto.CryptoUtils_BinaryBuffer;

public abstract class CryptoRsa {
    private static final CryptoAse ase = new CryptoAse();
    private static final String HATENA = "?";
    private static final String SIG_SM = "::52cee64bb3a38f6403386519a39ac91c::";
    private static final String CHARSET = "UTF8";
    private static final String GENERATE_CODE = "03";

    protected static final byte[] blockXOR(byte[] a, byte[] b, byte[] ret) {
        if (ret == null) {
            ret = new byte[16];
        }
        for (int i = 0; i < 16; ++i) {
            ret[i] = (byte)(a[i] & 0xFF ^ b[i] & 0xFF);
        }
        return ret;
    }

    protected static final byte[] blockIV(byte[] ret) throws Exception {
        if (ret == null) {
            ret = new byte[16];
        }
        CryptoRsaKey.getRand().nextBytes(ret);
        return ret;
    }

    protected static final byte[] pad16(byte[] block) {
        int len = block.length;
        int padding = 16 - (len & 0xF) & 0xF;
        int lenLen = len + padding;
        byte[] newBytes = new byte[lenLen];
        System.arraycopy(block, 0, newBytes, 0, len);
        return newBytes;
    }

    protected static final byte[] depad(byte[] bytes) {
        int len = bytes.length;
        int p = -1;
        for (int i = len - 1; i >= 0; --i) {
            if (bytes[i] == 0) continue;
            p = i;
            byte[] ret = new byte[p + 1];
            System.arraycopy(bytes, 0, ret, 0, p + 1);
            return ret;
        }
        return bytes;
    }

    protected static final String bytes2string(byte[] bin) {
        int len = bin.length;
        StringBuilder buf = new StringBuilder(bin.length);
        for (int i = 0; i < len; ++i) {
            buf.append((char)(bin[i] & 0xFF));
        }
        return buf.toString();
    }

    protected static final byte[] string2bytes(String string) {
        int len = string.length();
        byte[] ret = new byte[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = (byte)(string.charAt(i) & 0xFF);
        }
        return ret;
    }

    protected static final byte[] cloneBytes(byte[] bin) {
        byte[] ret = new byte[bin.length];
        System.arraycopy(bin, 0, ret, 0, bin.length);
        return ret;
    }

    protected static final byte[] cutBytes(byte[] src, int p, int e, byte[] ret) {
        int len = e - p;
        if (ret == null) {
            ret = new byte[len];
        }
        System.arraycopy(src, p, ret, 0, len);
        return ret;
    }

    protected static final byte[] addBytes(byte[] src, byte[] addBin) {
        int len = src.length + addBin.length;
        byte[] ret = new byte[len];
        System.arraycopy(src, 0, ret, 0, src.length);
        System.arraycopy(addBin, 0, ret, src.length, addBin.length);
        return ret;
    }

    protected static final byte[] nextAddBytes(byte[] src, int pos, byte[] addBin) {
        System.arraycopy(addBin, 0, src, pos, addBin.length);
        return src;
    }

    protected static final String encryptAESCBC(byte[] blocks, byte[] key) throws Exception {
        byte[] exKey = CryptoRsa.cloneBytes(key);
        exKey = ase.expandKey(exKey);
        blocks = CryptoRsa.pad16(blocks);
        byte[] encryptedBlocks = CryptoRsa.blockIV(null);
        int len = blocks.length;
        int loopLen = len / 16;
        byte[] tmp = new byte[loopLen * 16 + 16];
        System.arraycopy(encryptedBlocks, 0, tmp, 0, encryptedBlocks.length);
        encryptedBlocks = tmp;
        tmp = null;
        byte[] tmpBlock = new byte[16];
        byte[] previewBlock = new byte[16];
        int p = 16;
        for (int i = 0; i < loopLen; ++i) {
            CryptoRsa.cutBytes(blocks, i * 16, i * 16 + 16, tmpBlock);
            CryptoRsa.cutBytes(encryptedBlocks, i * 16, i * 16 + 16, previewBlock);
            CryptoRsa.blockXOR(previewBlock, tmpBlock, tmpBlock);
            ase.encrypt(tmpBlock, exKey);
            CryptoRsa.nextAddBytes(encryptedBlocks, p, tmpBlock);
            p += 16;
        }
        return CryptoUtils_Base64.encode(encryptedBlocks);
    }

    protected static final byte[] decryptAESCBC(String encryptedText, byte[] key) throws Exception {
        byte[] exKey = CryptoRsa.cloneBytes(key);
        exKey = ase.expandKey(exKey);
        byte[] encryptedBlocks = CryptoUtils_Base64.decode(encryptedText);
        int len = encryptedBlocks.length;
        int loopLen = len / 16;
        byte[] tmpBlock = new byte[16];
        byte[] previewBlock = new byte[16];
        CryptoUtils_BinaryBuffer decryptedBlocks = new CryptoUtils_BinaryBuffer();
        for (int i = 1; i < loopLen; ++i) {
            CryptoRsa.cutBytes(encryptedBlocks, i * 16, i * 16 + 16, tmpBlock);
            CryptoRsa.cutBytes(encryptedBlocks, (i - 1) * 16, (i - 1) * 16 + 16, previewBlock);
            ase.decrypt(tmpBlock, exKey);
            CryptoRsa.blockXOR(previewBlock, tmpBlock, tmpBlock);
            decryptedBlocks.write(tmpBlock);
        }
        return CryptoRsa.depad(decryptedBlocks.getBinary());
    }

    protected static final byte[] generateAESKey(byte[] ret) throws Exception {
        if (ret == null) {
            ret = new byte[32];
        }
        CryptoRsaKey.getRand().nextBytes(ret);
        return ret;
    }

    public static final CryptoRsaKey generateRSAKey(String passphrase, int bits) throws Exception {
        if (passphrase == null || passphrase.length() <= 0) {
            throw new IllegalArgumentException("passphrase\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (bits <= 0) {
            bits = 512;
        }
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.reset();
        md.update(passphrase.getBytes(CHARSET));
        CryptoRsaKey.getRand().setSeed(md.digest());
        CryptoRsaKey ret = new CryptoRsaKey();
        ret.generate(bits, GENERATE_CODE);
        return ret;
    }

    public static final String publicKeyString(CryptoRsaKey rsa) throws Exception {
        if (rsa == null || rsa.n == null) {
            throw new IllegalArgumentException("RSAKey\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        return CryptoUtils_Base64.encode(rsa.n.toByteArray());
    }

    public static final CryptoRsaKey publicKeyFromString(String string) throws Exception {
        if (string == null || string.length() <= 0) {
            throw new IllegalArgumentException("publicKey\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        int p = string.indexOf("|");
        if (p != -1) {
            string = string.substring(0, p);
        }
        CryptoRsaKey ret = new CryptoRsaKey();
        ret.setPublic(CryptoUtils_Base64.decode(string), GENERATE_CODE);
        return ret;
    }

    public static final String encrypt(String string, String publicKey, CryptoRsaKey signingKey) throws Exception {
        byte[] binary;
        if (string == null || string.length() <= 0) {
            throw new IllegalArgumentException("\u5bfe\u8c61\u306e\u6587\u5b57\u5217\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (publicKey == null || publicKey.length() <= 0) {
            throw new IllegalArgumentException("publicKey\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        byte[] aesKey = CryptoRsa.generateAESKey(null);
        StringBuilder ret = new StringBuilder(string.length() * 4);
        CryptoRsaKey publickey = CryptoRsa.publicKeyFromString(publicKey);
        ret.append(CryptoUtils_Base64.encode(publickey.encrypt(CryptoRsa.bytes2string(aesKey)))).append(HATENA);
        if (signingKey != null) {
            String signString = CryptoUtils_Base64.encode(signingKey.sign(string.getBytes(CHARSET), "sha256").toByteArray());
            string = string + SIG_SM + CryptoRsa.publicKeyString(signingKey) + SIG_SM + signString;
            binary = string.getBytes(CHARSET);
        } else {
            binary = string.getBytes(CHARSET);
        }
        ret.append(CryptoRsa.encryptAESCBC(binary, aesKey));
        return ret.toString();
    }

    public static final String decrypt(String string, CryptoRsaKey privateKey, CryptoRsaKey signingKey) throws Exception {
        if (string == null || string.length() <= 0) {
            throw new IllegalArgumentException("\u5bfe\u8c61\u306e\u6587\u5b57\u5217\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("privateKey\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        String[] cipherBlock = string.split("\\?");
        String tmpKey = privateKey.decrypt(CryptoUtils_Base64.decode(cipherBlock[0]));
        if (tmpKey == null) {
            throw new CryptoRsaFailureException("\u5fa9\u53f7\u51e6\u7406\u306b\u5931\u6557");
        }
        byte[] aesKey = CryptoRsa.string2bytes(tmpKey);
        tmpKey = null;
        String[] plainText = new String(CryptoRsa.decryptAESCBC(cipherBlock[1], aesKey), CHARSET).split(SIG_SM);
        if (plainText.length == 3) {
            if (signingKey != null) {
                CryptoRsaKey publickey = CryptoRsa.publicKeyFromString(plainText[1]);
                byte[] signature = CryptoUtils_Base64.decode(plainText[2]);
                if (publickey.verify(plainText[0].getBytes(CHARSET), signature) && CryptoRsa.publicKeyString(signingKey).equals(CryptoRsa.publicKeyString(publickey))) {
                    return plainText[0];
                }
                throw new CryptoRsaNotSigningException("\u7f72\u540d\u51e6\u7406\u306b\u5931\u6557");
            }
            throw new CryptoRsaNotSigningException("\u7f72\u540d\u51e6\u7406\u306b\u5931\u6557");
        }
        return plainText[0];
    }
}

