package org.seasar.dao.command;

import org.seasar.dao.CommandContext;
import org.seasar.dao.Node;
import org.seasar.dao.SqlCommand;
import org.seasar.dao.context.CommandContextImpl;
import org.seasar.dao.parser.SqlParserImpl;

/**
 * @author higa
 *  
 */
public abstract class AbstractCommand implements SqlCommand {

	private String sql_;
	private Node rootNode_;
	private String[] argNames_;

	public AbstractCommand() {
	}

	public String getSql() {
		return sql_;
	}

	public void setSql(String sql) {
		sql_ = sql;
		rootNode_ = new SqlParserImpl(sql).parse();
	}

	public String[] getArgNames() {
		return argNames_;
	}

	public void setArgNames(String[] argNames) {
		argNames_ = argNames;
	}

	public CommandContext apply(Object[] args) {
		CommandContext ctx = createCommandContext(args);
		rootNode_.accept(ctx);
		return ctx;
	}

	public CommandContext createCommandContext(Object[] args) {
		CommandContext ctx = new CommandContextImpl();
		for (int i = 0; i < argNames_.length; ++i) {
			if (i < args.length) {
				ctx.addArg(argNames_[i], args[i]);
			} else {
				ctx.addArg(argNames_[i], null);
			}
		}
		return ctx;
	}
}