package org.seasar.dao.command;

import javax.sql.DataSource;

import org.seasar.dao.CommandContext;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.impl.BasicSelectHandler;

/**
 * @author higa
 *  
 */
public class SelectCommand extends AbstractCommand {

	private ResultSetHandler resultSetHandler_;
	
	public SelectCommand() {
	}
	
	public ResultSetHandler getResultSetHandler() {
		return resultSetHandler_;
	}
	
	public void setResultSetHandler(ResultSetHandler resultSetHandler) {
		resultSetHandler_ = resultSetHandler;
	}

	public Object execute(DataSource ds, Object[] args) {
		CommandContext ctx = apply(args);
		BasicSelectHandler selectHandler =
			new BasicSelectHandler(ds, ctx.getSql(),
					resultSetHandler_);
		return selectHandler.execute(ctx.getBindVariables());
	}

}