/*
 * 쐬F 2004/09/07
 */
package org.seasar.tapestry.pageinjection;

import java.lang.reflect.Method;

import org.seasar.framework.container.S2Container;

/**
 * @author maruo_syunsuke
 */
public class InjectionUtil {
	private InjectionUtil() {}
	
	public static void injectionTypeS( 	S2Container container, 
				Class runClass,
				Object target) {
		Method[] methods = runClass.getDeclaredMethods();
		for (int i = 0; i < methods.length; i++) {
			Method method = methods[i];
			if (method.getName().startsWith("set") == false)
				continue;

			Class[] classes = method.getParameterTypes();
			if (classes.length != 1)
				continue;

			Class clazz = classes[0];
			if (clazz.isPrimitive())
				continue;

			if (container.hasComponentDef(clazz) == false)
				continue;

			try {
				Object injectObject = container.getComponent(clazz);
				if (injectObject != null) {
					method.invoke(target, new Object[] { injectObject });
				}
			} catch (Exception e) {
			}
		}
	}
}