/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.flex;

import flashgateway.io.ASObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.ClassUtil;
import org.w3c.dom.Document;

public class ASTranslator {
    private static final String REMOTE_CLASS = "_remoteClass";

    public Object fromActionScript(Object obj) {
        return this.fromActionScript(obj, new HashMap());
    }

    protected boolean needConvert(Object obj) {
        return !(obj instanceof String) && obj != null && !(obj instanceof Number) && !(obj instanceof Date) && !(obj instanceof Boolean) && !(obj instanceof Document);
    }

    protected Object fromActionScript(Object obj, Map shared) {
        if (this.needConvert(obj)) {
            if (obj instanceof List) {
                return this.fromList((List)obj, shared);
            }
            if (obj instanceof ASObject) {
                if (shared.containsKey(obj)) {
                    return shared.get(obj);
                }
                return this.fromASObject((ASObject)obj, shared);
            }
            return obj;
        }
        return obj;
    }

    protected List fromList(List list, Map shared) {
        ArrayList<Object> newList = new ArrayList<Object>();
        int i = 0;
        while (i < list.size()) {
            newList.add(this.fromActionScript(list.get(i), shared));
            ++i;
        }
        return newList;
    }

    protected Object fromASObject(ASObject obj, Map shared) {
        String type = obj.getType();
        if (type == null) {
            type = (String)obj.get((Object)REMOTE_CLASS);
        }
        if (type == null) {
            return obj;
        }
        Class clazz = ClassUtil.forName((String)type);
        Object bean = ClassUtil.newInstance((Class)clazz);
        shared.put(obj, bean);
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)clazz);
        Iterator i = obj.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!beanDesc.hasPropertyDesc(key)) continue;
            Object value = this.fromActionScript(obj.get((Object)key), shared);
            PropertyDesc pd = beanDesc.getPropertyDesc(key);
            if (!pd.hasWriteMethod()) continue;
            pd.setValue(bean, value);
        }
        return bean;
    }
}

