/*
 * Decompiled with CFR 0.152.
 */
package org.openamf;

import java.security.Principal;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openamf.AMFBody;
import org.openamf.DefaultGateway;
import org.openamf.ServiceRequest;
import org.openamf.config.FilterConfig;
import org.openamf.config.OpenAMFConfig;
import org.openamf.config.ServiceConfig;
import org.openamf.config.ServiceMethodAccessConstraintConfig;
import org.openamf.config.ServiceMethodConfig;
import org.openamf.config.ServiceMethodParameterConfig;
import org.openamf.config.StateBeanConfig;
import org.openamf.filter.FilterException;
import org.openamf.filter.ResultFilter;
import org.openamf.invoker.AccessDeniedException;
import org.openamf.invoker.ServiceInvocationException;
import org.openamf.invoker.ServiceInvoker;

public class AdvancedGateway
extends DefaultGateway {
    private static Log log = LogFactory.getLog((Class)(class$org$openamf$AdvancedGateway == null ? (class$org$openamf$AdvancedGateway = AdvancedGateway.class$("org.openamf.AdvancedGateway")) : class$org$openamf$AdvancedGateway));
    static /* synthetic */ Class class$org$openamf$AdvancedGateway;

    protected ServiceInvoker getServiceInvoker(AMFBody requestBody, HttpServletRequest httpServletRequest) throws ServiceInvocationException {
        ServiceInvoker serviceInvoker = null;
        try {
            ServiceConfig serviceConfig = this.getServiceConfig(requestBody);
            ServiceRequest request = new ServiceRequest(requestBody, serviceConfig);
            ServiceMethodConfig methodConfig = this.getMethodConfig(serviceConfig, request);
            if (methodConfig == null) {
                NoSuchMethodException e = new NoSuchMethodException(request.getRequestBody().toString());
                log.warn((Object)("Method config not found: " + request.getRequestBody().toString()));
                throw e;
            }
            request.setServiceMethodConfig(methodConfig);
            Iterator constraints = methodConfig.getAccessConstraintConfigs();
            if (constraints.hasNext()) {
                boolean accessDenied = true;
                while (accessDenied && constraints.hasNext()) {
                    ServiceMethodAccessConstraintConfig constraint = (ServiceMethodAccessConstraintConfig)constraints.next();
                    accessDenied = !httpServletRequest.isUserInRole(constraint.getRoleName());
                }
                if (accessDenied) {
                    Principal user = httpServletRequest.getUserPrincipal();
                    throw new AccessDeniedException(user == null ? "<anonymous user>" : user.getName());
                }
            }
            this.addStateBeansToParams(httpServletRequest, request, methodConfig);
            serviceInvoker = ServiceInvoker.load(serviceConfig.getServiceInvokerConfig().getClassName(), request, httpServletRequest, this.getServletContext());
            serviceInvoker.prepare(request);
        }
        catch (Exception e) {
            throw new ServiceInvocationException(requestBody, (Throwable)e);
        }
        return serviceInvoker;
    }

    private void addStateBeansToParams(HttpServletRequest httpServletRequest, ServiceRequest request, ServiceMethodConfig methodConfig) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (methodConfig != null) {
            Iterator stateBeans = methodConfig.getStateBeanConfigs();
            while (stateBeans.hasNext()) {
                Object stateBean = null;
                StateBeanConfig stateBeanConfig = (StateBeanConfig)stateBeans.next();
                stateBean = stateBeanConfig.isApplicationScope() ? this.getServletContext().getAttribute(stateBeanConfig.getClassName()) : httpServletRequest.getSession().getAttribute(stateBeanConfig.getClassName());
                if (stateBean == null) {
                    log.info((Object)("Loading " + stateBeanConfig.getClassName()));
                    Class<?> stateBeanClass = Thread.currentThread().getContextClassLoader().loadClass(stateBeanConfig.getClassName());
                    stateBean = stateBeanClass.newInstance();
                    if (stateBeanConfig.isApplicationScope()) {
                        log.info((Object)("Storing " + stateBeanConfig.getClassName() + " in ServletContext"));
                        this.getServletContext().setAttribute(stateBeanConfig.getClassName(), stateBean);
                    } else {
                        log.info((Object)("Storing " + stateBeanConfig.getClassName() + " in HttpSession"));
                        httpServletRequest.getSession().setAttribute(stateBeanConfig.getClassName(), stateBean);
                    }
                } else if (stateBeanConfig.isApplicationScope()) {
                    log.info((Object)("Got " + stateBeanConfig.getClassName() + " from ServletContext"));
                } else {
                    log.info((Object)("Got " + stateBeanConfig.getClassName() + " from HttpSession"));
                }
                request.addParameter(stateBean);
            }
        }
    }

    protected Object postInvokeService(HttpServletRequest httpServletRequest, ServiceInvoker serviceInvoker, Object serviceResult) throws ServiceInvocationException {
        ServiceMethodConfig methodConfig = serviceInvoker.getRequest().getServiceMethodConfig();
        try {
            if (methodConfig != null) {
                Iterator rfcs = methodConfig.getResultFilterConfigs();
                while (rfcs.hasNext()) {
                    FilterConfig fc = (FilterConfig)rfcs.next();
                    serviceResult = this.filterResult(serviceResult, fc);
                }
            }
        }
        catch (Exception e) {
            throw new ServiceInvocationException(serviceInvoker.getRequest(), (Throwable)e);
        }
        return super.postInvokeService(httpServletRequest, serviceInvoker, serviceResult);
    }

    private Object filterResult(Object serviceResult, FilterConfig filterConfig) throws ClassNotFoundException, InstantiationException, IllegalAccessException, FilterException {
        log.debug((Object)("loading filter class: " + filterConfig.getClassName()));
        Class<?> filterClass = Thread.currentThread().getContextClassLoader().loadClass(filterConfig.getClassName());
        ResultFilter resultFilter = (ResultFilter)filterClass.newInstance();
        log.info((Object)("calling Filter: " + filterConfig.getClassName()));
        return resultFilter.filter(serviceResult, filterConfig);
    }

    private ServiceConfig getServiceConfig(AMFBody requestBody) {
        ServiceConfig serviceConfig = OpenAMFConfig.getInstance().getServiceConfig(requestBody.getServiceName());
        return serviceConfig;
    }

    private ServiceMethodConfig getMethodConfig(ServiceConfig serviceConfig, ServiceRequest request) throws ClassNotFoundException {
        log.debug((Object)("getting MethodConfig for " + request.getServiceMethodName()));
        ServiceMethodConfig methodConfig = null;
        List parameters = request.getParameters();
        Iterator smcs = serviceConfig.getMethodConfigs();
        block0: while (smcs.hasNext()) {
            ServiceMethodConfig smc = (ServiceMethodConfig)smcs.next();
            String smcName = smc.getName();
            log.debug((Object)("service method config name: " + smcName));
            if (!"*".equals(smcName) && !smcName.equals(request.getServiceMethodName())) continue;
            log.debug((Object)"name matches, now to compare params");
            int paramIndex = -1;
            Iterator sopcs = smc.getParameterConfigs();
            while (sopcs.hasNext()) {
                ++paramIndex;
                ServiceMethodParameterConfig sopc = (ServiceMethodParameterConfig)sopcs.next();
                if (sopc.getType().equals("*")) {
                    log.debug((Object)"matches the rest");
                    methodConfig = smc;
                    break block0;
                }
                if (!sopc.getType().equals("?") && !this.typesMatch(parameters, paramIndex, sopc)) continue;
                if (paramIndex == parameters.size() - 1) {
                    log.debug((Object)"all parameters match");
                    methodConfig = smc;
                    break block0;
                }
                log.debug((Object)"this parameter matches, contine checking the rest");
            }
        }
        return methodConfig;
    }

    private boolean typesMatch(List parameters, int paramIndex, ServiceMethodParameterConfig sopc) throws ClassNotFoundException {
        boolean typesMatch = false;
        Class<?> typeClass = Thread.currentThread().getContextClassLoader().loadClass(sopc.getType());
        if (typeClass.isInstance(parameters.get(paramIndex))) {
            typesMatch = true;
        }
        return typesMatch;
    }

    public String getServletInfo() {
        return "OpenAMF AdvancedGateway servlet, http://www.openamf.org/";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

