/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.hsqldb.Column;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashSet;

public class SetFunction {
    private HashSet distinctValues;
    private boolean isDistinct;
    private int setType;
    private int type;
    private int count;
    private long currentLong;
    private double currentDouble;
    private BigDecimal currentBigDecimal;
    private Object currentValue;
    private LongSum longSum;

    SetFunction(int n, int n2, boolean bl) {
        this.setType = n;
        this.type = n2;
        if (bl) {
            this.isDistinct = true;
            this.distinctValues = new HashSet();
        }
        if (n2 == -5 && (n == 41 || n == 44)) {
            this.longSum = new LongSum();
        }
    }

    void add(Object object) throws HsqlException {
        if (object == null) {
            return;
        }
        if (this.isDistinct && !this.distinctValues.add(object)) {
            return;
        }
        ++this.count;
        switch (this.setType) {
            case 40: {
                return;
            }
            case 41: 
            case 44: {
                switch (this.type) {
                    case -6: 
                    case 4: 
                    case 5: {
                        this.currentLong += (long)((Number)object).intValue();
                        return;
                    }
                    case -5: {
                        this.longSum.add(((Number)object).longValue());
                        return;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        this.currentDouble += ((Number)object).doubleValue();
                        return;
                    }
                    case 2: 
                    case 3: {
                        this.currentBigDecimal = this.currentBigDecimal == null ? (BigDecimal)object : this.currentBigDecimal.add((BigDecimal)object);
                        return;
                    }
                }
                throw Trace.error(15);
            }
            case 42: {
                if (this.currentValue == null) {
                    this.currentValue = object;
                    return;
                }
                if (Column.compare(this.currentValue, object, this.type) > 0) {
                    this.currentValue = object;
                }
                return;
            }
            case 43: {
                if (this.currentValue == null) {
                    this.currentValue = object;
                    return;
                }
                if (Column.compare(this.currentValue, object, this.type) < 0) {
                    this.currentValue = object;
                }
                return;
            }
        }
    }

    Object getValue() throws HsqlException {
        if (this.setType == 40) {
            return new Integer(this.count);
        }
        if (this.count == 0) {
            return null;
        }
        switch (this.setType) {
            case 44: {
                switch (this.type) {
                    case -6: 
                    case 4: 
                    case 5: {
                        return new Long(this.currentLong / (long)this.count);
                    }
                    case -5: {
                        long l = this.longSum.getValue().divide(BigInteger.valueOf(this.count)).longValue();
                        return new Long(l);
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return new Double(this.currentDouble / (double)this.count);
                    }
                    case 2: 
                    case 3: {
                        return this.currentBigDecimal.divide(new BigDecimal((double)this.count), 5);
                    }
                }
                throw Trace.error(15);
            }
            case 41: {
                switch (this.type) {
                    case -6: 
                    case 4: 
                    case 5: {
                        return new Long(this.currentLong);
                    }
                    case -5: {
                        return new BigDecimal(this.longSum.getValue());
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return new Double(this.currentDouble);
                    }
                    case 2: 
                    case 3: {
                        return this.currentBigDecimal;
                    }
                }
                throw Trace.error(15);
            }
            case 42: 
            case 43: {
                return this.currentValue;
            }
        }
        throw Trace.error(95);
    }

    static int getType(int n, int n2) throws HsqlException {
        switch (n) {
            case 40: {
                return 4;
            }
            case 44: {
                switch (n2) {
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        return -5;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return 8;
                    }
                    case 2: 
                    case 3: {
                        return 3;
                    }
                }
                return 0;
            }
            case 41: {
                switch (n2) {
                    case -6: 
                    case 4: 
                    case 5: {
                        return -5;
                    }
                    case -5: {
                        return 3;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return 8;
                    }
                    case 2: 
                    case 3: {
                        return 3;
                    }
                }
                return 0;
            }
            case 42: 
            case 43: {
                return n2;
            }
        }
        throw Trace.error(95);
    }

    static class LongSum {
        static BigInteger multiplier = BigInteger.valueOf(0x100000000L);
        long hi;
        long lo;

        LongSum() {
        }

        void add(long l) {
            if (l != 0L) {
                if (l > 0L) {
                    this.hi += l >> 32;
                    this.lo += l & 0xFFFFFFFFL;
                } else if (l == Long.MIN_VALUE) {
                    this.hi -= 0x80000000L;
                } else {
                    long l2 = (l ^ 0xFFFFFFFFFFFFFFFFL) + 1L;
                    this.hi -= l2 >> 32;
                    this.lo -= l2 & 0xFFFFFFFFL;
                }
            }
        }

        BigInteger getValue() throws HsqlException {
            BigInteger bigInteger = BigInteger.valueOf(this.lo);
            BigInteger bigInteger2 = BigInteger.valueOf(this.hi);
            BigInteger bigInteger3 = bigInteger2.multiply(multiplier).add(bigInteger);
            return bigInteger3;
        }
    }
}

