/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.unit;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.seasar.extension.dataset.ColumnType;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.impl.SqlDeleteTableWriter;
import org.seasar.extension.dataset.impl.SqlReloadReader;
import org.seasar.extension.dataset.impl.SqlReloadTableReader;
import org.seasar.extension.dataset.impl.SqlTableReader;
import org.seasar.extension.dataset.impl.SqlWriter;
import org.seasar.extension.dataset.impl.XlsReader;
import org.seasar.extension.dataset.impl.XlsWriter;
import org.seasar.extension.dataset.types.ColumnTypes;
import org.seasar.extension.jdbc.impl.BasicUpdateHandler;
import org.seasar.extension.unit.BeanListReader;
import org.seasar.extension.unit.BeanReader;
import org.seasar.extension.unit.MapListReader;
import org.seasar.extension.unit.MapReader;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.exception.NoSuchMethodRuntimeException;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ConnectionUtil;
import org.seasar.framework.util.DataSourceUtil;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.FileOutputStreamUtil;
import org.seasar.framework.util.MethodUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;

public class S2TestCase
extends TestCase {
    private static final String DATASOURCE_NAME = "j2ee.dataSource";
    private S2Container container_;
    private DataSource dataSource_;
    private Connection connection_;
    private DatabaseMetaData dbMetaData_;
    private List bindedFields_;
    static /* synthetic */ Class class$org$seasar$extension$unit$S2TestCase;
    static /* synthetic */ Class class$javax$transaction$TransactionManager;
    static /* synthetic */ Class class$javax$sql$DataSource;

    public S2TestCase(String name) {
        super(name);
    }

    public S2Container getContainer() {
        return this.container_;
    }

    public Object getComponent(String componentName) {
        return this.container_.getComponent((Object)componentName);
    }

    public Object getComponent(Class componentClass) {
        return this.container_.getComponent((Object)componentClass);
    }

    public ComponentDef getComponentDef(String componentName) {
        return this.container_.getComponentDef((Object)componentName);
    }

    public ComponentDef getComponentDef(Class componentClass) {
        return this.container_.getComponentDef((Object)componentClass);
    }

    public void register(Class componentClass) {
        this.container_.register(componentClass);
    }

    public void register(Class componentClass, String componentName) {
        this.container_.register(componentClass, componentName);
    }

    public void register(Object component) {
        this.container_.register(component);
    }

    public void register(Object component, String componentName) {
        this.container_.register(component, componentName);
    }

    public void register(ComponentDef componentDef) {
        this.container_.register(componentDef);
    }

    public void include(String path) {
        S2ContainerFactory.include((S2Container)this.container_, (String)this.convertPath(path));
    }

    private String convertPath(String path) {
        if (ResourceUtil.getResourceNoException((String)path) != null) {
            return path;
        }
        String prefix = ((Object)((Object)this)).getClass().getPackage().getName().replace('.', '/');
        return prefix + "/" + path;
    }

    public DataSource getDataSource() {
        if (this.dataSource_ == null) {
            throw new EmptyRuntimeException("dataSource");
        }
        return this.dataSource_;
    }

    public Connection getConnection() {
        if (this.connection_ != null) {
            return this.connection_;
        }
        this.connection_ = DataSourceUtil.getConnection((DataSource)this.getDataSource());
        return this.connection_;
    }

    public DatabaseMetaData getDatabaseMetaData() {
        if (this.dbMetaData_ != null) {
            return this.dbMetaData_;
        }
        this.dbMetaData_ = ConnectionUtil.getMetaData((Connection)this.getConnection());
        return this.dbMetaData_;
    }

    public DataSet readXls(String path) {
        XlsReader reader = new XlsReader(this.convertPath(path));
        return reader.read();
    }

    public void writeXls(String path, DataSet dataSet) {
        File dir = ResourceUtil.getBuildDir(((Object)((Object)this)).getClass());
        File file = new File(dir, this.convertPath(path));
        XlsWriter writer = new XlsWriter(FileOutputStreamUtil.create((File)file));
        writer.write(dataSet);
    }

    public void writeDb(DataSet dataSet) {
        SqlWriter writer = new SqlWriter(this.getDataSource());
        writer.write(dataSet);
    }

    public DataTable readDbByTable(String table) {
        return this.readDbByTable(table, null);
    }

    public DataTable readDbByTable(String table, String condition) {
        SqlTableReader reader = new SqlTableReader(this.getDataSource());
        reader.setTable(table, condition);
        return reader.read();
    }

    public DataTable readDbBySql(String sql, String tableName) {
        SqlTableReader reader = new SqlTableReader(this.getDataSource());
        reader.setSql(sql, tableName);
        return reader.read();
    }

    public void readXlsWriteDb(String path) {
        this.writeDb(this.readXls(path));
    }

    public void readXlsReplaceDb(String path) {
        DataSet dataSet = this.readXls(path);
        this.deleteDb(dataSet);
        this.writeDb(dataSet);
    }

    public void readXlsAllReplaceDb(String path) {
        DataSet dataSet = this.readXls(path);
        int i = dataSet.getTableSize() - 1;
        while (i >= 0) {
            this.deleteTable(dataSet.getTable(i).getTableName());
            --i;
        }
        this.writeDb(dataSet);
    }

    public DataSet reload(DataSet dataSet) {
        return new SqlReloadReader(this.getDataSource(), dataSet).read();
    }

    public DataTable reload(DataTable table) {
        return new SqlReloadTableReader(this.getDataSource(), table).read();
    }

    public void deleteDb(DataSet dataSet) {
        SqlDeleteTableWriter writer = new SqlDeleteTableWriter(this.getDataSource());
        int i = dataSet.getTableSize() - 1;
        while (i >= 0) {
            writer.write(dataSet.getTable(i));
            --i;
        }
    }

    public void deleteTable(String tableName) {
        BasicUpdateHandler handler = new BasicUpdateHandler(this.getDataSource(), "DELETE FROM " + tableName);
        handler.execute(null);
    }

    public void assertEquals(DataSet expected, DataSet actual) {
        this.assertEquals(null, expected, actual);
    }

    public void assertEquals(String message, DataSet expected, DataSet actual) {
        message = message == null ? "" : message;
        Assert.assertEquals((String)(message + ":TableSize"), (int)expected.getTableSize(), (int)actual.getTableSize());
        int i = 0;
        while (i < expected.getTableSize()) {
            this.assertEquals(message, expected.getTable(i), actual.getTable(i));
            ++i;
        }
    }

    public void assertEquals(DataTable expected, DataTable actual) {
        this.assertEquals(null, expected, actual);
    }

    public void assertEquals(String message, DataTable expected, DataTable actual) {
        message = message == null ? "" : message;
        Assert.assertEquals((String)(message + ":RowSize"), (int)expected.getRowSize(), (int)actual.getRowSize());
        int i = 0;
        while (i < expected.getRowSize()) {
            DataRow expectedRow = expected.getRow(i);
            DataRow actualRow = actual.getRow(i);
            int j = 0;
            while (j < expected.getColumnSize()) {
                Object actualValue;
                String columnName = expected.getColumnName(j);
                Object expectedValue = expectedRow.getValue(columnName);
                ColumnType ct = ColumnTypes.getColumnType(expectedValue);
                if (!ct.equals(expectedValue, actualValue = actualRow.getValue(columnName))) {
                    Assert.assertEquals((String)(message + ":Row=" + i + ":columnName=" + columnName), (Object)expectedValue, (Object)actualValue);
                }
                ++j;
            }
            ++i;
        }
    }

    public void assertEquals(DataSet expected, Object actual) {
        this.assertEquals(null, expected, actual);
    }

    public void assertEquals(String message, DataSet expected, Object actual) {
        Assert.assertNotNull((Object)expected);
        Assert.assertNotNull((Object)actual);
        Object beanClass = null;
        if (actual instanceof List) {
            List actualList = (List)actual;
            Assert.assertFalse((boolean)actualList.isEmpty());
            Object actualItem = actualList.get(0);
            if (actualItem instanceof Map) {
                this.assertMapListEquals(message, expected, actualList);
            } else {
                this.assertBeanListEquals(message, expected, actualList);
            }
        } else if (actual instanceof Map) {
            this.assertMapEquals(message, expected, (Map)actual);
        } else {
            this.assertBeanEquals(message, expected, actual);
        }
    }

    protected void assertMapEquals(String message, DataSet expected, Map map) {
        MapReader reader = new MapReader(map);
        this.assertEquals(message, expected, reader.read());
    }

    protected void assertMapListEquals(String message, DataSet expected, List list) {
        MapListReader reader = new MapListReader(list);
        this.assertEquals(message, expected, reader.read());
    }

    protected void assertBeanEquals(String message, DataSet expected, Object bean) {
        BeanReader reader = new BeanReader(bean);
        this.assertEquals(message, expected, reader.read());
    }

    protected void assertBeanListEquals(String message, DataSet expected, List list) {
        BeanListReader reader = new BeanListReader(list);
        this.assertEquals(message, expected, reader.read());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        this.container_ = new S2ContainerImpl();
        this.setUp();
        try {
            this.setUpForEachTestMethod();
            try {
                this.container_.init();
                try {
                    this.setupDataSource();
                    try {
                        this.setUpAfterContainerInit();
                        this.bindFields();
                        try {
                            this.runTestTx();
                            Object var2_1 = null;
                            this.unbindFields();
                        }
                        catch (Throwable throwable) {
                            Object var2_2 = null;
                            this.unbindFields();
                            throw throwable;
                        }
                        this.tearDownBeforeContainerDestroy();
                        Object var4_4 = null;
                        this.tearDownDataSource();
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        this.tearDownDataSource();
                        throw throwable;
                    }
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    this.container_.destroy();
                    throw throwable;
                }
                this.container_.destroy();
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                this.tearDownForEachTestMethod();
                throw throwable;
            }
            this.tearDownForEachTestMethod();
            Object var10_13 = null;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            this.tearDown();
            throw throwable;
        }
        this.tearDown();
    }

    protected void setUpAfterContainerInit() throws Throwable {
    }

    protected void setUpForEachTestMethod() throws Throwable {
        this.invoke("setUp" + this.getTargetName());
    }

    protected void tearDownBeforeContainerDestroy() throws Throwable {
    }

    protected void tearDownForEachTestMethod() throws Throwable {
        this.invoke("tearDown" + this.getTargetName());
    }

    private String getTargetName() {
        return this.getName().substring(4);
    }

    private void invoke(String methodName) throws Throwable {
        try {
            Method method = ClassUtil.getMethod(((Object)((Object)this)).getClass(), (String)methodName, null);
            MethodUtil.invoke((Method)method, (Object)((Object)this), null);
        }
        catch (NoSuchMethodRuntimeException noSuchMethodRuntimeException) {
            // empty catch block
        }
    }

    private void bindFields() throws Throwable {
        this.bindedFields_ = new ArrayList();
        Class<?> clazz = ((Object)((Object)this)).getClass();
        while (clazz != (class$org$seasar$extension$unit$S2TestCase == null ? S2TestCase.class$("org.seasar.extension.unit.S2TestCase") : class$org$seasar$extension$unit$S2TestCase) && clazz != null) {
            Field[] fields = clazz.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                this.bindField(fields[i]);
                ++i;
            }
            clazz = clazz.getSuperclass();
        }
    }

    private void bindField(Field field) {
        if (this.isAutoBindable(field)) {
            field.setAccessible(true);
            if (FieldUtil.get((Field)field, (Object)((Object)this)) != null) {
                return;
            }
            String name = this.normalizeName(field.getName());
            Object component = null;
            if (this.getContainer().hasComponentDef((Object)name) && field.getType().isAssignableFrom(this.getComponentDef(name).getComponentClass())) {
                component = this.getComponent(name);
            } else if (this.getContainer().hasComponentDef(field.getType())) {
                component = this.getComponent(field.getType());
            }
            if (component != null) {
                FieldUtil.set((Field)field, (Object)((Object)this), (Object)component);
                this.bindedFields_.add(field);
            }
        }
    }

    private String normalizeName(String name) {
        return StringUtil.replace((String)name, (String)"_", (String)"");
    }

    private boolean isAutoBindable(Field field) {
        int modifiers = field.getModifiers();
        return !Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers) && !field.getType().isPrimitive();
    }

    private void unbindFields() {
        int i = 0;
        while (i < this.bindedFields_.size()) {
            Field field = (Field)this.bindedFields_.get(i);
            try {
                field.set((Object)this, null);
            }
            catch (IllegalArgumentException e) {
                System.err.println(e);
            }
            catch (IllegalAccessException e) {
                System.err.println(e);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runTestTx() throws Throwable {
        TransactionManager tm = null;
        if (this.needTransaction()) {
            try {
                tm = (TransactionManager)this.getComponent(class$javax$transaction$TransactionManager == null ? (class$javax$transaction$TransactionManager = S2TestCase.class$("javax.transaction.TransactionManager")) : class$javax$transaction$TransactionManager);
                tm.begin();
            }
            catch (Throwable t) {
                System.err.println(t);
            }
        }
        try {
            this.runTest();
            Object var4_3 = null;
            if (tm == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (tm == null) throw throwable;
            tm.rollback();
            throw throwable;
        }
        tm.rollback();
    }

    private boolean needTransaction() {
        return this.getName().endsWith("Tx");
    }

    private void setupDataSource() {
        try {
            if (this.container_.hasComponentDef((Object)DATASOURCE_NAME)) {
                this.dataSource_ = (DataSource)this.container_.getComponent((Object)DATASOURCE_NAME);
            } else if (this.container_.hasComponentDef((Object)(class$javax$sql$DataSource == null ? (class$javax$sql$DataSource = S2TestCase.class$("javax.sql.DataSource")) : class$javax$sql$DataSource))) {
                this.dataSource_ = (DataSource)this.container_.getComponent((Object)(class$javax$sql$DataSource == null ? (class$javax$sql$DataSource = S2TestCase.class$("javax.sql.DataSource")) : class$javax$sql$DataSource));
            }
        }
        catch (Throwable t) {
            System.err.println(t);
        }
    }

    private void tearDownDataSource() {
        this.dbMetaData_ = null;
        if (this.connection_ != null) {
            ConnectionUtil.close((Connection)this.connection_);
            this.connection_ = null;
        }
        this.dataSource_ = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DATASOURCE_NAME = DATASOURCE_NAME;
    }
}

