/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Properties;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.util.ResourceNotFoundRuntimeException;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.URLUtil;

public final class ResourceUtil {
    private ResourceUtil() {
    }

    public static String getResourcePath(String path, String extension) {
        if (extension == null) {
            return path;
        }
        if (path.endsWith(extension = "." + extension)) {
            return path;
        }
        return String.valueOf(path.replace('.', '/')) + extension;
    }

    public static String getResourcePath(Class clazz) {
        return String.valueOf(clazz.getName().replace('.', '/')) + ".class";
    }

    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static URL getResource(String path) {
        return ResourceUtil.getResource(path, null);
    }

    public static URL getResource(String path, String extension) throws ResourceNotFoundRuntimeException {
        URL url = ResourceUtil.getResourceNoException(path, extension);
        if (url != null) {
            return url;
        }
        throw new ResourceNotFoundRuntimeException(ResourceUtil.getResourcePath(path, extension));
    }

    public static URL getResourceNoException(String path) {
        return ResourceUtil.getResourceNoException(path, null);
    }

    public static URL getResourceNoException(String path, String extension) {
        path = ResourceUtil.getResourcePath(path, extension);
        return ResourceUtil.getClassLoader().getResource(path);
    }

    public static InputStream getResourceAsStream(String path) {
        return ResourceUtil.getResourceAsStream(path, null);
    }

    public static InputStream getResourceAsStream(String path, String extension) {
        URL url = ResourceUtil.getResource(path, extension);
        return URLUtil.openStream(url);
    }

    public static boolean isExist(String path) {
        return ResourceUtil.getResourceNoException(path) != null;
    }

    public static Properties getProperties(String path) {
        Properties props = new Properties();
        InputStream is = ResourceUtil.getResourceAsStream(path);
        try {
            props.load(is);
            return props;
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    public static String getExtension(String path) {
        int extPos = path.lastIndexOf(".");
        if (extPos >= 0) {
            return path.substring(extPos + 1);
        }
        return null;
    }

    public static File getBuildDir(Class clazz) {
        URL url = ResourceUtil.getResource(ResourceUtil.getResourcePath(clazz));
        int num = StringUtil.split(clazz.getName(), ".").length;
        File file = new File(ResourceUtil.getFileName(url));
        int i = 0;
        while (i < num) {
            ++i;
            file = file.getParentFile();
        }
        return file;
    }

    public static String toExternalForm(URL url) {
        String s = url.toExternalForm();
        try {
            return URLDecoder.decode(s, "UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public static String getFileName(URL url) {
        String s = url.getFile();
        try {
            return URLDecoder.decode(s, "UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public static File getFile(URL url) {
        return new File(ResourceUtil.getFileName(url));
    }

    public static File getResourceAsFile(String path) {
        return ResourceUtil.getResourceAsFile(path, null);
    }

    public static File getResourceAsFile(String path, String extension) {
        return ResourceUtil.getFile(ResourceUtil.getResource(path, extension));
    }
}

