/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.core;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;
import org.objectweb.asm.Type;

public class ReflectUtils {
    private static final Map primitives = new HashMap(8);
    private static final Map transforms = new HashMap(8);
    private static final ClassLoader defaultLoader = (class$net$sf$cglib$core$ReflectUtils == null ? (class$net$sf$cglib$core$ReflectUtils = ReflectUtils.class$("net.sf.cglib.core.ReflectUtils")) : class$net$sf$cglib$core$ReflectUtils).getClassLoader();
    private static Method DEFINE_CLASS;
    private static final ProtectionDomain PROTECTION_DOMAIN;
    private static final String[] CGLIB_PACKAGES;
    static /* synthetic */ Class class$net$sf$cglib$core$ReflectUtils;
    static /* synthetic */ Class class$java$lang$Object;

    private ReflectUtils() {
    }

    public static Type[] getExceptionTypes(Member member) {
        if (member instanceof Method) {
            return TypeUtils.getTypes(((Method)member).getExceptionTypes());
        }
        if (member instanceof Constructor) {
            return TypeUtils.getTypes(((Constructor)member).getExceptionTypes());
        }
        throw new IllegalArgumentException("Cannot get exception types of a field");
    }

    public static Signature getSignature(Member member) {
        if (member instanceof Method) {
            return new Signature(member.getName(), Type.getMethodDescriptor((Method)((Method)member)));
        }
        if (member instanceof Constructor) {
            Type[] types = TypeUtils.getTypes(((Constructor)member).getParameterTypes());
            return new Signature("<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])types));
        }
        throw new IllegalArgumentException("Cannot get signature of a field");
    }

    public static Constructor findConstructor(String desc) {
        return ReflectUtils.findConstructor(desc, defaultLoader);
    }

    public static Constructor findConstructor(String desc, ClassLoader loader) {
        try {
            int lparen = desc.indexOf(40);
            String className = desc.substring(0, lparen).trim();
            return ReflectUtils.getClass(className, loader).getConstructor(ReflectUtils.parseTypes(desc, loader));
        }
        catch (ClassNotFoundException e) {
            throw new CodeGenerationException(e);
        }
        catch (NoSuchMethodException e) {
            throw new CodeGenerationException(e);
        }
    }

    public static Method findMethod(String desc) {
        return ReflectUtils.findMethod(desc, defaultLoader);
    }

    public static Method findMethod(String desc, ClassLoader loader) {
        try {
            int lparen = desc.indexOf(40);
            int dot = desc.lastIndexOf(46, lparen);
            String className = desc.substring(0, dot).trim();
            String methodName = desc.substring(dot + 1, lparen).trim();
            return ReflectUtils.getClass(className, loader).getDeclaredMethod(methodName, ReflectUtils.parseTypes(desc, loader));
        }
        catch (ClassNotFoundException e) {
            throw new CodeGenerationException(e);
        }
        catch (NoSuchMethodException e) {
            throw new CodeGenerationException(e);
        }
    }

    private static Class[] parseTypes(String desc, ClassLoader loader) throws ClassNotFoundException {
        int comma;
        int lparen = desc.indexOf(40);
        int rparen = desc.indexOf(41, lparen);
        ArrayList<String> params = new ArrayList<String>();
        int start = lparen + 1;
        while ((comma = desc.indexOf(44, start)) >= 0) {
            params.add(desc.substring(start, comma).trim());
            start = comma + 1;
        }
        if (start < rparen) {
            params.add(desc.substring(start, rparen).trim());
        }
        Class[] types = new Class[params.size()];
        int i = 0;
        while (i < types.length) {
            types[i] = ReflectUtils.getClass((String)params.get(i), loader);
            ++i;
        }
        return types;
    }

    private static Class getClass(String className, ClassLoader loader) throws ClassNotFoundException {
        return ReflectUtils.getClass(className, loader, CGLIB_PACKAGES);
    }

    /*
     * Unable to fully structure code
     */
    private static Class getClass(String className, ClassLoader loader, String[] packages) throws ClassNotFoundException {
        save = className;
        dimensions = 0;
        index = 0;
        while ((index = className.indexOf("[]", index) + 1) > 0) {
            ++dimensions;
        }
        brackets = new StringBuffer(className.length() - dimensions);
        i = 0;
        while (i < dimensions) {
            brackets.append('[');
            ++i;
        }
        className = className.substring(0, className.length() - 2 * dimensions);
        prefix = dimensions > 0 ? brackets + "L" : "";
        suffix = dimensions > 0 ? ";" : "";
        try {
            return Class.forName(prefix + className + suffix, false, loader);
        }
        catch (ClassNotFoundException ignore) {
            i = 0;
            ** while (i < packages.length)
        }
lbl-1000:
        // 1 sources

        {
            try {
                return Class.forName(prefix + packages[i] + '.' + className + suffix, false, loader);
            }
            catch (ClassNotFoundException ignore) {
                ++i;
            }
            continue;
        }
lbl27:
        // 1 sources

        if (dimensions == 0) {
            c = (Class)ReflectUtils.primitives.get(className);
            if (c != null) {
                return c;
            }
        } else {
            transform = (String)ReflectUtils.transforms.get(className);
            if (transform != null) {
                try {
                    return Class.forName(brackets + transform, false, loader);
                }
                catch (ClassNotFoundException ignore) {
                    // empty catch block
                }
            }
        }
        throw new ClassNotFoundException(save);
    }

    public static Object newInstance(Class type) {
        return ReflectUtils.newInstance(type, Constants.EMPTY_CLASS_ARRAY, null);
    }

    public static Object newInstance(Class type, Class[] parameterTypes, Object[] args) {
        return ReflectUtils.newInstance(ReflectUtils.getConstructor(type, parameterTypes), args);
    }

    public static Object newInstance(Constructor cstruct, Object[] args) {
        boolean flag = cstruct.isAccessible();
        try {
            try {
                Object result;
                ((AccessibleObject)cstruct).setAccessible(true);
                Object t = result = cstruct.newInstance(args);
                Object var7_7 = null;
                ((AccessibleObject)cstruct).setAccessible(flag);
                return t;
            }
            catch (InstantiationException e) {
                throw new CodeGenerationException(e);
            }
            catch (IllegalAccessException e) {
                throw new CodeGenerationException(e);
            }
            catch (InvocationTargetException e) {
                throw new CodeGenerationException(e.getTargetException());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            ((AccessibleObject)cstruct).setAccessible(flag);
            throw throwable;
        }
    }

    public static Constructor getConstructor(Class type, Class[] parameterTypes) {
        try {
            return type.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new CodeGenerationException(e);
        }
    }

    public static Class[] getClasses(Object[] objects) {
        Class[] classes = new Class[objects.length];
        int i = 0;
        while (i < objects.length) {
            classes[i] = objects[i].getClass();
            ++i;
        }
        return classes;
    }

    public static Method findNewInstance(Class iface) {
        Method m = ReflectUtils.findInterfaceMethod(iface);
        if (!m.getName().equals("newInstance")) {
            throw new IllegalArgumentException(iface + " missing newInstance method");
        }
        return m;
    }

    public static Method[] getPropertyMethods(PropertyDescriptor[] properties, boolean read, boolean write) {
        HashSet<Method> methods = new HashSet<Method>();
        int i = 0;
        while (i < properties.length) {
            PropertyDescriptor pd = properties[i];
            if (read) {
                methods.add(pd.getReadMethod());
            }
            if (write) {
                methods.add(pd.getWriteMethod());
            }
            ++i;
        }
        methods.remove(null);
        return methods.toArray(new Method[methods.size()]);
    }

    public static PropertyDescriptor[] getBeanProperties(Class type) {
        return ReflectUtils.getPropertiesHelper(type, true, true);
    }

    public static PropertyDescriptor[] getBeanGetters(Class type) {
        return ReflectUtils.getPropertiesHelper(type, true, false);
    }

    public static PropertyDescriptor[] getBeanSetters(Class type) {
        return ReflectUtils.getPropertiesHelper(type, false, true);
    }

    private static PropertyDescriptor[] getPropertiesHelper(Class type, boolean read, boolean write) {
        try {
            BeanInfo info = Introspector.getBeanInfo(type, class$java$lang$Object == null ? (class$java$lang$Object = ReflectUtils.class$("java.lang.Object")) : class$java$lang$Object);
            PropertyDescriptor[] all = info.getPropertyDescriptors();
            if (read && write) {
                return all;
            }
            ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(all.length);
            int i = 0;
            while (i < all.length) {
                PropertyDescriptor pd = all[i];
                if (read && pd.getReadMethod() != null || write && pd.getWriteMethod() != null) {
                    properties.add(pd);
                }
                ++i;
            }
            return properties.toArray(new PropertyDescriptor[properties.size()]);
        }
        catch (IntrospectionException e) {
            throw new CodeGenerationException(e);
        }
    }

    public static Method findDeclaredMethod(Class type, String methodName, Class[] parameterTypes) throws NoSuchMethodException {
        Class cl = type;
        while (cl != null) {
            try {
                return cl.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                cl = cl.getSuperclass();
            }
        }
        throw new NoSuchMethodException(methodName);
    }

    public static List addAllMethods(Class type, List list) {
        list.addAll(Arrays.asList(type.getDeclaredMethods()));
        Class superclass = type.getSuperclass();
        if (superclass != null) {
            ReflectUtils.addAllMethods(superclass, list);
        }
        Class<?>[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            ReflectUtils.addAllMethods(interfaces[i], list);
            ++i;
        }
        return list;
    }

    public static List addAllInterfaces(Class type, List list) {
        Class superclass = type.getSuperclass();
        if (superclass != null) {
            list.addAll(Arrays.asList(type.getInterfaces()));
            ReflectUtils.addAllInterfaces(superclass, list);
        }
        return list;
    }

    public static Method findInterfaceMethod(Class iface) {
        if (!iface.isInterface()) {
            throw new IllegalArgumentException(iface + " is not an interface");
        }
        Method[] methods = iface.getDeclaredMethods();
        if (methods.length != 1) {
            throw new IllegalArgumentException("expecting exactly 1 method in " + iface);
        }
        return methods[0];
    }

    public static Class defineClass(String className, byte[] b, ClassLoader loader) throws Exception {
        Object[] args = new Object[]{className, b, new Integer(0), new Integer(b.length), PROTECTION_DOMAIN};
        return (Class)DEFINE_CLASS.invoke((Object)loader, args);
    }

    public static int findPackageProtected(Class[] classes) {
        int i = 0;
        while (i < classes.length) {
            if (!Modifier.isPublic(classes[i].getModifiers())) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PROTECTION_DOMAIN = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){
            static /* synthetic */ Class class$net$sf$cglib$core$ReflectUtils;

            public Object run() {
                return (class$net$sf$cglib$core$ReflectUtils == null ? (class$net$sf$cglib$core$ReflectUtils = 1.class$("net.sf.cglib.core.ReflectUtils")) : class$net$sf$cglib$core$ReflectUtils).getProtectionDomain();
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
        AccessController.doPrivileged(new PrivilegedAction(){
            static /* synthetic */ Class class$java$lang$String;
            static /* synthetic */ Class array$B;
            static /* synthetic */ Class class$java$security$ProtectionDomain;
            static /* synthetic */ Class class$java$lang$ClassLoader;

            public Object run() {
                try {
                    DEFINE_CLASS = (2.class$java$lang$ClassLoader == null ? (2.class$java$lang$ClassLoader = 2.class$("java.lang.ClassLoader")) : 2.class$java$lang$ClassLoader).getDeclaredMethod("defineClass", 2.class$java$lang$String == null ? (2.class$java$lang$String = 2.class$("java.lang.String")) : 2.class$java$lang$String, 2.array$B == null ? (2.array$B = 2.class$("[B")) : 2.array$B, Integer.TYPE, Integer.TYPE, 2.class$java$security$ProtectionDomain == null ? (2.class$java$security$ProtectionDomain = 2.class$("java.security.ProtectionDomain")) : 2.class$java$security$ProtectionDomain);
                    ((AccessibleObject)DEFINE_CLASS).setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    throw new CodeGenerationException(e);
                }
                return null;
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
        CGLIB_PACKAGES = new String[]{"java.lang"};
        primitives.put("byte", Byte.TYPE);
        primitives.put("char", Character.TYPE);
        primitives.put("double", Double.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("int", Integer.TYPE);
        primitives.put("long", Long.TYPE);
        primitives.put("short", Short.TYPE);
        primitives.put("boolean", Boolean.TYPE);
        transforms.put("byte", "B");
        transforms.put("char", "C");
        transforms.put("double", "D");
        transforms.put("float", "F");
        transforms.put("int", "I");
        transforms.put("long", "J");
        transforms.put("short", "S");
        transforms.put("boolean", "Z");
    }
}

