/*
 * Decompiled with CFR 0.152.
 */
package javax.faces;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;

public final class FactoryFinder {
    public static final String APPLICATION_FACTORY = "javax.faces.application.ApplicationFactory";
    public static final String FACES_CONTEXT_FACTORY = "javax.faces.context.FacesContextFactory";
    public static final String LIFECYCLE_FACTORY = "javax.faces.lifecycle.LifecycleFactory";
    public static final String RENDER_KIT_FACTORY = "javax.faces.render.RenderKitFactory";
    private static Map _registeredFactoryNames = new HashMap();
    private static Map _factories = new HashMap();
    private static final Set VALID_FACTORY_NAMES = new HashSet();
    private static final Map ABSTRACT_FACTORY_CLASSES = new HashMap();
    static /* synthetic */ Class class$javax$faces$application$ApplicationFactory;
    static /* synthetic */ Class class$javax$faces$context$FacesContextFactory;
    static /* synthetic */ Class class$javax$faces$lifecycle$LifecycleFactory;
    static /* synthetic */ Class class$javax$faces$render$RenderKitFactory;

    public static Object getFactory(String factoryName) throws FacesException {
        Object factory;
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        Map factoryClassNames = (Map)_registeredFactoryNames.get(classLoader);
        if (factoryClassNames == null) {
            String message = "No Factories configured for this Application - typically this is because a context listener is not setup in your web.xml.\nA typical config looks like this;\n<listener>\n  <listener-class>net.sourceforge.myfaces.webapp.StartupServletContextListener</listener-class>\n</listener>\n";
            throw new IllegalStateException(message);
        }
        if (!factoryClassNames.containsKey(factoryName)) {
            throw new IllegalStateException("no factory " + factoryName + " configured for this appliction");
        }
        HashMap factoryMap = (HashMap)_factories.get(classLoader);
        if (factoryMap == null) {
            factoryMap = new HashMap();
            _factories.put(classLoader, factoryMap);
        }
        if ((factory = factoryMap.get(factoryName)) == null) {
            List classNames = (List)factoryClassNames.get(factoryName);
            factory = FactoryFinder.newFactoryInstance((Class)ABSTRACT_FACTORY_CLASSES.get(factoryName), classNames.iterator(), classLoader);
            factoryMap.put(factoryName, factory);
            return factory;
        }
        return factory;
    }

    private static Object newFactoryInstance(Class interfaceClass, Iterator classNamesIterator, ClassLoader classLoader) {
        try {
            Object current = null;
            while (classNamesIterator.hasNext()) {
                String implClassName = (String)classNamesIterator.next();
                Class<?> implClass = classLoader.loadClass(implClassName);
                if (!interfaceClass.isAssignableFrom(implClass)) {
                    throw new IllegalArgumentException("Class " + implClassName + " is no " + interfaceClass.getName());
                }
                if (current == null) {
                    current = implClass.newInstance();
                    continue;
                }
                try {
                    Constructor<?> delegationConstructor = implClass.getConstructor(interfaceClass);
                    try {
                        current = delegationConstructor.newInstance(current);
                    }
                    catch (InstantiationException e) {
                        throw new FacesException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new FacesException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new FacesException(e);
                    }
                }
                catch (NoSuchMethodException e) {
                    current = implClass.newInstance();
                }
            }
            return current;
        }
        catch (ClassNotFoundException e) {
            throw new FacesException(e);
        }
        catch (InstantiationException e) {
            throw new FacesException(e);
        }
        catch (IllegalAccessException e) {
            throw new FacesException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFactory(String factoryName, String implName) {
        FactoryFinder.checkFactoryName(factoryName);
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        Map map = _registeredFactoryNames;
        synchronized (map) {
            ArrayList<String> classNameList;
            Map factories = (Map)_factories.get(classLoader);
            if (factories != null && factories.containsKey(factoryName)) {
                return;
            }
            HashMap<String, ArrayList<String>> factoryClassNames = (HashMap<String, ArrayList<String>>)_registeredFactoryNames.get(classLoader);
            if (factoryClassNames == null) {
                factoryClassNames = new HashMap<String, ArrayList<String>>();
                _registeredFactoryNames.put(classLoader, factoryClassNames);
            }
            if ((classNameList = (ArrayList<String>)factoryClassNames.get(factoryName)) == null) {
                classNameList = new ArrayList<String>();
                factoryClassNames.put(factoryName, classNameList);
            }
            classNameList.add(implName);
        }
    }

    public static void releaseFactories() throws FacesException {
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        _factories.remove(classLoader);
    }

    private static void checkFactoryName(String factoryName) {
        if (!VALID_FACTORY_NAMES.contains(factoryName)) {
            throw new IllegalArgumentException("factoryName '" + factoryName + "'");
        }
    }

    private static ClassLoader getClassLoader() {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                throw new FacesException("web application class loader cannot be identified", null);
            }
            return classLoader;
        }
        catch (Exception e) {
            throw new FacesException("web application class loader cannot be identified", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        VALID_FACTORY_NAMES.add(APPLICATION_FACTORY);
        VALID_FACTORY_NAMES.add(FACES_CONTEXT_FACTORY);
        VALID_FACTORY_NAMES.add(LIFECYCLE_FACTORY);
        VALID_FACTORY_NAMES.add(RENDER_KIT_FACTORY);
        ABSTRACT_FACTORY_CLASSES.put(APPLICATION_FACTORY, class$javax$faces$application$ApplicationFactory == null ? (class$javax$faces$application$ApplicationFactory = FactoryFinder.class$(APPLICATION_FACTORY)) : class$javax$faces$application$ApplicationFactory);
        ABSTRACT_FACTORY_CLASSES.put(FACES_CONTEXT_FACTORY, class$javax$faces$context$FacesContextFactory == null ? (class$javax$faces$context$FacesContextFactory = FactoryFinder.class$(FACES_CONTEXT_FACTORY)) : class$javax$faces$context$FacesContextFactory);
        ABSTRACT_FACTORY_CLASSES.put(LIFECYCLE_FACTORY, class$javax$faces$lifecycle$LifecycleFactory == null ? (class$javax$faces$lifecycle$LifecycleFactory = FactoryFinder.class$(LIFECYCLE_FACTORY)) : class$javax$faces$lifecycle$LifecycleFactory);
        ABSTRACT_FACTORY_CLASSES.put(RENDER_KIT_FACTORY, class$javax$faces$render$RenderKitFactory == null ? (class$javax$faces$render$RenderKitFactory = FactoryFinder.class$(RENDER_KIT_FACTORY)) : class$javax$faces$render$RenderKitFactory);
    }
}

