/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.el;

import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.VariableResolver;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.jsf.el.ApplicationScopeResolver;
import org.seasar.jsf.el.CookieResolver;
import org.seasar.jsf.el.FacesContextResolver;
import org.seasar.jsf.el.FacesResolver;
import org.seasar.jsf.el.HeaderResolver;
import org.seasar.jsf.el.HeaderValuesResolver;
import org.seasar.jsf.el.InitParamResolver;
import org.seasar.jsf.el.ParamResolver;
import org.seasar.jsf.el.ParamValuesResolver;
import org.seasar.jsf.el.RequestScopeResolver;
import org.seasar.jsf.el.SessionScopeResolver;
import org.seasar.jsf.el.ViewResolver;
import org.seasar.jsf.util.BindingUtil;

public class S2VariableResolver
extends VariableResolver {
    private static final String APPLICATION_SCOPE = "applicationScope";
    private static final String COOKIE = "cookie";
    private static final String FACES_CONTEXT = "facesContext";
    private static final String HEADER = "header";
    private static final String HEADER_VALUES = "headerValues";
    private static final String INIT_PARAM = "initParam";
    private static final String PARAM = "param";
    private static final String PARAM_VALUES = "paramValues";
    private static final String REQUEST_SCOPE = "requestScope";
    private static final String SESSION_SCOPE = "sessionScope";
    private static final String VIEW = "view";
    private static Map facesResolvers_ = new HashMap();

    static {
        facesResolvers_.put(APPLICATION_SCOPE, new ApplicationScopeResolver());
        facesResolvers_.put(COOKIE, new CookieResolver());
        facesResolvers_.put(FACES_CONTEXT, new FacesContextResolver());
        facesResolvers_.put(HEADER, new HeaderResolver());
        facesResolvers_.put(HEADER_VALUES, new HeaderValuesResolver());
        facesResolvers_.put(INIT_PARAM, new InitParamResolver());
        facesResolvers_.put(PARAM, new ParamResolver());
        facesResolvers_.put(PARAM_VALUES, new ParamValuesResolver());
        facesResolvers_.put(REQUEST_SCOPE, new RequestScopeResolver());
        facesResolvers_.put(SESSION_SCOPE, new SessionScopeResolver());
        facesResolvers_.put(VIEW, new ViewResolver());
    }

    public Object resolveVariable(FacesContext context, String name) throws EvaluationException {
        FacesResolver resolver = (FacesResolver)facesResolvers_.get(name);
        if (resolver != null) {
            return resolver.resolveVariable(context);
        }
        S2Container container = SingletonS2ContainerFactory.getContainer();
        return BindingUtil.getValue(container, name);
    }
}

