/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.render.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import javax.servlet.http.HttpServletRequest;
import org.seasar.jsf.component.html.HtmlBase;
import org.seasar.jsf.util.FacesContextUtil;

public class HtmlBaseRenderer
extends Renderer {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("base", component);
        HtmlBase base = (HtmlBase)component;
        String href = base.getHref();
        if (href == null) {
            HttpServletRequest request = FacesContextUtil.getRequest(context);
            href = this.calculateHref(request);
        }
        writer.writeAttribute("href", (Object)href, null);
        String target = base.getTarget();
        if (target != null) {
            writer.writeAttribute("target", (Object)target, null);
        }
        writer.endElement("base");
    }

    public String calculateHref(HttpServletRequest request) {
        StringBuffer url = new StringBuffer();
        url.append(request.getScheme());
        url.append("://");
        url.append(request.getServerName());
        url.append(':');
        url.append(request.getServerPort());
        url.append(request.getRequestURI());
        return url.toString();
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }
}

