/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.runtime;

import java.io.IOException;
import java.io.InputStream;
import org.cyberneko.html.parsers.SAXParser;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.exception.SAXRuntimeException;
import org.seasar.jsf.JsfConfig;
import org.seasar.jsf.TagProcessor;
import org.seasar.jsf.TagProcessorTreeFactory;
import org.seasar.jsf.TagSelector;
import org.seasar.jsf.runtime.TagProcessorHandler;
import org.seasar.jsf.runtime.TagSelectors;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TagProcessorTreeFactoryImpl
implements TagProcessorTreeFactory {
    private TagSelectors tagSelectors = new TagSelectors();
    private String encoding = "Windows-31j";
    private JsfConfig jsfConfig;

    public TagProcessor createTagProcessorTree(InputStream is) {
        SAXParser parser = this.createParser();
        TagProcessorHandler handler = new TagProcessorHandler(this.tagSelectors, this.jsfConfig);
        parser.setContentHandler((ContentHandler)handler);
        try {
            parser.parse(new InputSource(is));
        }
        catch (SAXException ex) {
            throw new SAXRuntimeException(ex);
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
        return handler.getRoot();
    }

    public void addTagSelector(TagSelector tagSelector) {
        this.tagSelectors.addTagSelector(tagSelector);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setPagesConfig(JsfConfig jsfConfig) {
        this.jsfConfig = jsfConfig;
    }

    protected SAXParser createParser() {
        SAXParser parser = new SAXParser();
        try {
            parser.setProperty("http://cyberneko.org/html/properties/default-encoding", (Object)this.encoding);
            parser.setProperty("http://cyberneko.org/html/properties/names/attrs", (Object)"default");
            parser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"match");
        }
        catch (SAXException ex) {
            throw new SAXRuntimeException(ex);
        }
        return parser;
    }
}

